package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.foundation.costmanage.api.CostanalysisApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("purchasesettlement")
public class PurchasesettlementBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IPurchasesettlementService service;
	@Autowired
	private CostanalysisApi costanalysisApi;
	@Autowired
	private IPurchasesettlementdetailService purchasesettlementdetailService;

	@Autowired
	private IParamConfigApi paramConfigApi;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasesettlementEntity entity = service.selectById(billId);
//		CommonResponse<Boolean> response = costanalysisApi.isGenerate(entity.getProjectId(),entity.getOccurrenceTime());
//		if(response != null){
//			Boolean isHave = response.getData();
//			if(isHave != null && isHave.booleanValue()){
//				return CommonResponse.error("该单据所属项目与月份已生成月度分析报告，不可提交！");
//			}
//		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();

	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//创建条件构造器
		QueryWrapper<PurchasesettlementdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", billId);
		queryWrapper.eq("dr", "0");
		List<PurchasesettlementdetailEntity> detailEntities = purchasesettlementdetailService.list(queryWrapper);
		if(detailEntities != null && detailEntities.size() > 0){
			for (int i = 0; i < detailEntities.size(); i++) {
				PurchasesettlementdetailEntity detail = detailEntities.get(i);
				detail.setBillState(state);//更新子表审批状态
			}

			purchasesettlementdetailService.saveOrUpdateBatch(detailEntities);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//查询是否生成月度分析报告
		QueryWrapper<PurchasesettlementEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("id",billId);
		PurchasesettlementEntity entity1 = service.getOne(queryWrapper1);
//		CommonResponse<Boolean> generate = costanalysisApi.isGenerate(entity1.getProjectId(), entity1.getOccurrenceTime());
//		if(generate.isSuccess() && generate.getData()){
//			return CommonResponse.error("该单据已经生成月度分析报告，不可进行操作！");
//		}

		PurchasesettlementEntity entity = service.selectById(billId);
		Long contractId = entity.getContractId();//合同id

		//只能弃审最新的单据
		QueryWrapper<PurchasesettlementEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByDesc("create_time");
		queryWrapper.last("limit 1");
		List<PurchasesettlementEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			PurchasesettlementEntity resEntity = pro.get(0);
			Integer billState = resEntity.getBillState();
			if(!billId.equals(resEntity.getId())){//本单据不是最新
				if(billState == 1 || billState == 3){
					return CommonResponse.error("只能弃审该合同下最后一次做的已生效单据！");
				}else {
					return CommonResponse.error("已存在一个审批中或自由态的最新单据，不允许弃审！");
				}
			}else{
				if(resEntity.getIsReference() == 1){
					return CommonResponse.error("被汇总单引用的单据不允许撤回！");
				}
			}
		}

		//报表已生成, 数据已被抓取的不能撤回
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode("P-P29C0z0304");
		if (!byCode.isSuccess()){
			throw new BusinessException("获取参数失败");
		}
		ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
		String valueData = paramRegisterSetVO.getValueData();
		Date reportingTime = entity.getOccurrenceTime();
//获取对应数据的报表生成日期
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		calendar.setTime(reportingTime);
		calendar.add(Calendar.MONTH, 1);
		Date date = calendar.getTime();
		String period = sdf.format(date);
		String limit = period + "-"+valueData;
		SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date limitDate = ft.parse(limit);
			if (new Date().after(limitDate)){
				return CommonResponse.error("当前单据已生成运营分析报表,不能撤回!");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}




		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//创建条件构造器
		QueryWrapper<PurchasesettlementdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", billId);
		queryWrapper.eq("dr", "0");
		List<PurchasesettlementdetailEntity> detailEntities = purchasesettlementdetailService.list(queryWrapper);
		if(detailEntities != null && detailEntities.size() > 0){
			for (int i = 0; i < detailEntities.size(); i++) {
				PurchasesettlementdetailEntity detail = detailEntities.get(i);
				detail.setBillState(state);//更新子表审批状态
			}

			purchasesettlementdetailService.saveOrUpdateBatch(detailEntities);
		}
		return CommonResponse.success();
	}

}
