package com.ejianc.business.middlemeasurement.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 分包经济签证单
 *
 * @author generator
 *
 */
public class SubcontractEconomicVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String engineeringOrderIssue; // 工程指令签发事项
    private List<String> engineeringOrderIssueList;//工程指令签发事项多选
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private BigDecimal economicVisaAmount; // 经济签证金额
    private BigDecimal reportedValue; //  报送值（元）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subcontractingSubmissionDate; // 分包报送日期
    private String visaContent; // 签证内容
    private String amountCalculationProcess; // 签证金额计算过程
    private String subcontractor; // 分包人
    private String entrustSubcontractor; // 分包委托人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subcontractingPrincipalDate; // 分包委托人签字日期
    private String deductionSubcontractor; // 转扣分包人
    private String deductionEntrustSubcontractor; // 转扣分包委托人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subContractingPrincipaDate; // 转扣分包委托人签字日期
    private String opinionProjectProfessionalEngineer; // 项目专业工程师意见
    private String projectProfessionalEngineerSignature; // 项目专业工程师签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectProfessionalEngineerDate; // 项目专业工程师签字日期
    private String reviewedProjectBusinessManager; // 项目商务经理审核
    private String projectBusinessManagerSignature; // 项目商务经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectBusinessManagerDate; // 项目商务经理签字日期
    private String opinionProjectChiefEngineer; // 项目总工（或生产经理）意见
    private String projectChiefEngineerSignature; // 项目总工（或生产经理）签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectChiefEngineerDate; // 项目总工（或生产经理）签字日期
    private String reviewedProjectManager; // 项目经理审核
    private String projectManagerSignature; // 项目经理签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectManagerDate; // 项目经理签字日期
    private String businessManagementDepartmentOperator; // 分/子公司商务管理部经办人
    private String businessManagementDepartmentOperatorSignature; // 分/子公司商务管理部经办人签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date businessManagementDepartmentOperatorDate; // 分/子公司商务管理部经办人签字日期
    private String businessManagementDepartmentHead; // 分/子公司商务管理部负责人
    private String businessManagementDepartmentHeadSignature; // 分/子公司商务管理部负责人签字
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date businessManagementDepartmentHeadDate; // 分/子公司商务管理部负责人签字日期
    private String companyLeader; // 分/子公司分管领导（2万元及以上签证）
    private java.lang.String billStateStr;//单据状态
    private java.lang.String sort;

    private BigDecimal extaxVisaAmount;//签证金额（除税）
    private BigDecimal taxVisaAmount;//签证金额（税金）
    private BigDecimal intaxVisaAmount;//签证金额（含税）
    private BigDecimal extaxCasualLabour;//零星用工（除税）
    private BigDecimal taxCasualLabour;//零星用工（税金）
    private BigDecimal intaxCasualLabour;//零星用工（含税）
    private BigDecimal reporteDtaxlessValue; //   报送值(除税）
    private String itemType;   //事项类型
    private Long contractId;   //合同id
    private String contractName;   //合同名称
    private Long supplierId;   //供应商id
    private String supplierName;   //供应商名称
    private BigDecimal reportedDtaxlessValue; //  报送值(除税）
    private String engineeringInstructCode; // 工程指令单号
    private Long buckleUnit; // 转扣单位
    private String buckleUnitName; // 转扣单位名称
    private BigDecimal buckleCost; // 转扣金额

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date projectCreateTime; // 项目创建日期
    private Integer orgStatusOrder; // 二级组织排序
    private BigDecimal orgMny; //公司确认金额（除税）
    private BigDecimal orgTaxMny; //公司确认金额（含税）

    public BigDecimal getOrgMny() {
        return orgMny;
    }

    public void setOrgMny(BigDecimal orgMny) {
        this.orgMny = orgMny;
    }

    public BigDecimal getOrgTaxMny() {
        return orgTaxMny;
    }

    public void setOrgTaxMny(BigDecimal orgTaxMny) {
        this.orgTaxMny = orgTaxMny;
    }

    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }

    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }

    public BigDecimal getReportedDtaxlessValue() {
        return reportedDtaxlessValue;
    }

    public void setReportedDtaxlessValue(BigDecimal reportedDtaxlessValue) {
        this.reportedDtaxlessValue = reportedDtaxlessValue;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public BigDecimal getReporteDtaxlessValue() {
        return reporteDtaxlessValue;
    }

    public void setReporteDtaxlessValue(BigDecimal reporteDtaxlessValue) {
        this.reporteDtaxlessValue = reporteDtaxlessValue;
    }

    public BigDecimal getExtaxVisaAmount() {
        return extaxVisaAmount;
    }

    public void setExtaxVisaAmount(BigDecimal extaxVisaAmount) {
        this.extaxVisaAmount = extaxVisaAmount;
    }

    public BigDecimal getTaxVisaAmount() {
        return taxVisaAmount;
    }

    public void setTaxVisaAmount(BigDecimal taxVisaAmount) {
        this.taxVisaAmount = taxVisaAmount;
    }

    public BigDecimal getIntaxVisaAmount() {
        return intaxVisaAmount;
    }

    public void setIntaxVisaAmount(BigDecimal intaxVisaAmount) {
        this.intaxVisaAmount = intaxVisaAmount;
    }

    public BigDecimal getExtaxCasualLabour() {
        return extaxCasualLabour;
    }

    public void setExtaxCasualLabour(BigDecimal extaxCasualLabour) {
        this.extaxCasualLabour = extaxCasualLabour;
    }

    public BigDecimal getTaxCasualLabour() {
        return taxCasualLabour;
    }

    public void setTaxCasualLabour(BigDecimal taxCasualLabour) {
        this.taxCasualLabour = taxCasualLabour;
    }

    public BigDecimal getIntaxCasualLabour() {
        return intaxCasualLabour;
    }

    public void setIntaxCasualLabour(BigDecimal intaxCasualLabour) {
        this.intaxCasualLabour = intaxCasualLabour;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getEngineeringOrderIssue() {
        return engineeringOrderIssue;
    }

    public void setEngineeringOrderIssue(String engineeringOrderIssue) {
        this.engineeringOrderIssue = engineeringOrderIssue;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public BigDecimal getEconomicVisaAmount() {
        return economicVisaAmount;
    }

    public void setEconomicVisaAmount(BigDecimal economicVisaAmount) {
        this.economicVisaAmount = economicVisaAmount;
    }
    public BigDecimal getReportedValue() {
        return reportedValue;
    }

    public void setReportedValue(BigDecimal reportedValue) {
        this.reportedValue = reportedValue;
    }
    public Date getSubcontractingSubmissionDate() {
        return subcontractingSubmissionDate;
    }

    public void setSubcontractingSubmissionDate(Date subcontractingSubmissionDate) {
        this.subcontractingSubmissionDate = subcontractingSubmissionDate;
    }

    public String getVisaContent() {
        return visaContent;
    }

    public void setVisaContent(String visaContent) {
        this.visaContent = visaContent;
    }

    public String getAmountCalculationProcess() {
        return amountCalculationProcess;
    }

    public void setAmountCalculationProcess(String amountCalculationProcess) {
        this.amountCalculationProcess = amountCalculationProcess;
    }

    public String getSubcontractor() {
        return subcontractor;
    }

    public void setSubcontractor(String subcontractor) {
        this.subcontractor = subcontractor;
    }

    public Date getSubcontractingPrincipalDate() {
        return subcontractingPrincipalDate;
    }

    public void setSubcontractingPrincipalDate(Date subcontractingPrincipalDate) {
        this.subcontractingPrincipalDate = subcontractingPrincipalDate;
    }

    public Date getSubContractingPrincipaDate() {
        return subContractingPrincipaDate;
    }

    public void setSubContractingPrincipaDate(Date subContractingPrincipaDate) {
        this.subContractingPrincipaDate = subContractingPrincipaDate;
    }
    public String getOpinionProjectProfessionalEngineer() {
        return opinionProjectProfessionalEngineer;
    }

    public void setOpinionProjectProfessionalEngineer(String opinionProjectProfessionalEngineer) {
        this.opinionProjectProfessionalEngineer = opinionProjectProfessionalEngineer;
    }
    public String getProjectProfessionalEngineerSignature() {
        return projectProfessionalEngineerSignature;
    }

    public void setProjectProfessionalEngineerSignature(String projectProfessionalEngineerSignature) {
        this.projectProfessionalEngineerSignature = projectProfessionalEngineerSignature;
    }
    public Date getProjectProfessionalEngineerDate() {
        return projectProfessionalEngineerDate;
    }

    public void setProjectProfessionalEngineerDate(Date projectProfessionalEngineerDate) {
        this.projectProfessionalEngineerDate = projectProfessionalEngineerDate;
    }
    public String getReviewedProjectBusinessManager() {
        return reviewedProjectBusinessManager;
    }

    public void setReviewedProjectBusinessManager(String reviewedProjectBusinessManager) {
        this.reviewedProjectBusinessManager = reviewedProjectBusinessManager;
    }
    public String getProjectBusinessManagerSignature() {
        return projectBusinessManagerSignature;
    }

    public void setProjectBusinessManagerSignature(String projectBusinessManagerSignature) {
        this.projectBusinessManagerSignature = projectBusinessManagerSignature;
    }
    public Date getProjectBusinessManagerDate() {
        return projectBusinessManagerDate;
    }

    public void setProjectBusinessManagerDate(Date projectBusinessManagerDate) {
        this.projectBusinessManagerDate = projectBusinessManagerDate;
    }
    public String getOpinionProjectChiefEngineer() {
        return opinionProjectChiefEngineer;
    }

    public void setOpinionProjectChiefEngineer(String opinionProjectChiefEngineer) {
        this.opinionProjectChiefEngineer = opinionProjectChiefEngineer;
    }
    public String getProjectChiefEngineerSignature() {
        return projectChiefEngineerSignature;
    }

    public void setProjectChiefEngineerSignature(String projectChiefEngineerSignature) {
        this.projectChiefEngineerSignature = projectChiefEngineerSignature;
    }
    public Date getProjectChiefEngineerDate() {
        return projectChiefEngineerDate;
    }

    public void setProjectChiefEngineerDate(Date projectChiefEngineerDate) {
        this.projectChiefEngineerDate = projectChiefEngineerDate;
    }
    public String getReviewedProjectManager() {
        return reviewedProjectManager;
    }

    public void setReviewedProjectManager(String reviewedProjectManager) {
        this.reviewedProjectManager = reviewedProjectManager;
    }
    public String getProjectManagerSignature() {
        return projectManagerSignature;
    }

    public void setProjectManagerSignature(String projectManagerSignature) {
        this.projectManagerSignature = projectManagerSignature;
    }
    public Date getProjectManagerDate() {
        return projectManagerDate;
    }

    public void setProjectManagerDate(Date projectManagerDate) {
        this.projectManagerDate = projectManagerDate;
    }
    public String getBusinessManagementDepartmentOperator() {
        return businessManagementDepartmentOperator;
    }

    public void setBusinessManagementDepartmentOperator(String businessManagementDepartmentOperator) {
        this.businessManagementDepartmentOperator = businessManagementDepartmentOperator;
    }
    public String getBusinessManagementDepartmentOperatorSignature() {
        return businessManagementDepartmentOperatorSignature;
    }

    public void setBusinessManagementDepartmentOperatorSignature(String businessManagementDepartmentOperatorSignature) {
        this.businessManagementDepartmentOperatorSignature = businessManagementDepartmentOperatorSignature;
    }
    public Date getBusinessManagementDepartmentOperatorDate() {
        return businessManagementDepartmentOperatorDate;
    }

    public void setBusinessManagementDepartmentOperatorDate(Date businessManagementDepartmentOperatorDate) {
        this.businessManagementDepartmentOperatorDate = businessManagementDepartmentOperatorDate;
    }
    public String getBusinessManagementDepartmentHead() {
        return businessManagementDepartmentHead;
    }

    public void setBusinessManagementDepartmentHead(String businessManagementDepartmentHead) {
        this.businessManagementDepartmentHead = businessManagementDepartmentHead;
    }
    public String getBusinessManagementDepartmentHeadSignature() {
        return businessManagementDepartmentHeadSignature;
    }

    public void setBusinessManagementDepartmentHeadSignature(String businessManagementDepartmentHeadSignature) {
        this.businessManagementDepartmentHeadSignature = businessManagementDepartmentHeadSignature;
    }
    public Date getBusinessManagementDepartmentHeadDate() {
        return businessManagementDepartmentHeadDate;
    }

    public void setBusinessManagementDepartmentHeadDate(Date businessManagementDepartmentHeadDate) {
        this.businessManagementDepartmentHeadDate = businessManagementDepartmentHeadDate;
    }
    public String getCompanyLeader() {
        return companyLeader;
    }

    public void setCompanyLeader(String companyLeader) {
        this.companyLeader = companyLeader;
    }
    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public List<String> getEngineeringOrderIssueList() {
        return engineeringOrderIssueList;
    }

    public void setEngineeringOrderIssueList(List<String> engineeringOrderIssueList) {
        this.engineeringOrderIssueList = engineeringOrderIssueList;
    }

    public String getEntrustSubcontractor() {
        return entrustSubcontractor;
    }

    public void setEntrustSubcontractor(String entrustSubcontractor) {
        this.entrustSubcontractor = entrustSubcontractor;
    }

    public String getDeductionSubcontractor() {
        return deductionSubcontractor;
    }

    public void setDeductionSubcontractor(String deductionSubcontractor) {
        this.deductionSubcontractor = deductionSubcontractor;
    }

    public String getDeductionEntrustSubcontractor() {
        return deductionEntrustSubcontractor;
    }

    public void setDeductionEntrustSubcontractor(String deductionEntrustSubcontractor) {
        this.deductionEntrustSubcontractor = deductionEntrustSubcontractor;
    }

    public String getEngineeringInstructCode() {
        return engineeringInstructCode;
    }

    public void setEngineeringInstructCode(String engineeringInstructCode) {
        this.engineeringInstructCode = engineeringInstructCode;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getBuckleUnit() {
        return buckleUnit;
    }
    @ReferDeserialTransfer
    public void setBuckleUnit(Long buckleUnit) {
        this.buckleUnit = buckleUnit;
    }

    public String getBuckleUnitName() {
        return buckleUnitName;
    }

    public void setBuckleUnitName(String buckleUnitName) {
        this.buckleUnitName = buckleUnitName;
    }

    public BigDecimal getBuckleCost() {
        return buckleCost;
    }

    public void setBuckleCost(BigDecimal buckleCost) {
        this.buckleCost = buckleCost;
    }
}
