/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"engineermeasurementExport"})
public class ExcelEngineermeasurementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEngineermeasurementdetailService engineermeasurementdetailService;

    @RequestMapping(value={"/downloadEngineermeasurement"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadEngineermeasurement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"engineermeasurementdetail-import.xlsx", (String)"\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportEngineermeasurement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportEngineermeasurement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<EngineermeasurementdetailVO> successList = new ArrayList<EngineermeasurementdetailVO>();
        ArrayList<EngineermeasurementdetailVO> errorList = new ArrayList<EngineermeasurementdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = new EngineermeasurementdetailVO();
                List datas = (List)result.get(i);
                if (datas.size() > 12) {
                    return CommonResponse.error((String)"\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u662f\u5426\u6b63\u786e");
                }
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String imageProgressStr = (String)datas.get(1);
                String actualReportingValue = (String)datas.get(2);
                String nowActualDoneValue = (String)datas.get(3);
                String nowOwnerApprovalValue = (String)datas.get(4);
                String financialIncome = (String)datas.get(5);
                String contractApprovalTime = (String)datas.get(7);
                String actualReportingTime = (String)datas.get(8);
                String actualApprovalTime = (String)datas.get(9);
                String remarksStr = (String)datas.get(10);
                engineermeasurementdetailVO.setId(IdWorker.getId());
                engineermeasurementdetailVO.setActualReportingValue(StringUtils.isBlank((CharSequence)actualReportingValue) ? BigDecimal.ZERO : new BigDecimal(actualReportingValue));
                engineermeasurementdetailVO.setNowActualDoneValue(StringUtils.isBlank((CharSequence)nowActualDoneValue) ? BigDecimal.ZERO : new BigDecimal(nowActualDoneValue));
                engineermeasurementdetailVO.setNowOwnerApprovalValue(StringUtils.isBlank((CharSequence)nowOwnerApprovalValue) ? BigDecimal.ZERO : new BigDecimal(nowOwnerApprovalValue));
                engineermeasurementdetailVO.setFinancialIncome(StringUtils.isBlank((CharSequence)financialIncome) ? BigDecimal.ZERO : new BigDecimal(financialIncome));
                engineermeasurementdetailVO.setContractApprovalTime(StringUtils.isBlank((CharSequence)contractApprovalTime) ? null : new SimpleDateFormat("yyyy/MM/dd").parse(contractApprovalTime));
                engineermeasurementdetailVO.setActualReportingTime(StringUtils.isBlank((CharSequence)actualReportingTime) ? null : new SimpleDateFormat("yyyy/MM/dd").parse(actualReportingTime));
                engineermeasurementdetailVO.setActualApprovalTime(StringUtils.isBlank((CharSequence)actualApprovalTime) ? null : new SimpleDateFormat("yyyy/MM/dd").parse(actualApprovalTime));
                engineermeasurementdetailVO.setRemarks(remarksStr);
                if (StringUtils.isBlank((CharSequence)imageProgressStr)) {
                    engineermeasurementdetailVO.setErrorMsg("\u5f62\u8c61\u8fdb\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5f62\u8c61\u8fdb\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    engineermeasurementdetailVO.setImageProgress(imageProgressStr);
                }
                if (engineermeasurementdetailVO.getNowActualDoneValue() != null && engineermeasurementdetailVO.getNowOwnerApprovalValue() != null) {
                    engineermeasurementdetailVO.setRightConfirmationRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)engineermeasurementdetailVO.getNowOwnerApprovalValue(), (BigDecimal)engineermeasurementdetailVO.getNowActualDoneValue()), (BigDecimal)new BigDecimal(100)));
                } else {
                    engineermeasurementdetailVO.setRightConfirmationRate(BigDecimal.ZERO);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(engineermeasurementdetailVO);
                    continue;
                }
                successList.add(engineermeasurementdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportEngineermeasurementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEngineermeasurementFromDatabase(@RequestBody EngineermeasurementVO engineermeasurementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)engineermeasurementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.engineermeasurementdetailService.list((Wrapper)queryWrapper);
        List engineermeasurementdetailVOList = BeanMapper.mapList((Iterable)list, EngineermeasurementdetailVO.class);
        if (engineermeasurementdetailVOList != null && engineermeasurementdetailVOList.size() > 0) {
            for (int i = 0; i < engineermeasurementdetailVOList.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = (EngineermeasurementdetailVO)((Object)engineermeasurementdetailVOList.get(i));
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() == null) continue;
                engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", engineermeasurementdetailVOList);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportEngineermeasurementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEngineermeasurementFromPage(@RequestBody List<EngineermeasurementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = list.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() == null) continue;
                engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
            }
        }
        HashMap<String, List<EngineermeasurementdetailVO>> beans = new HashMap<String, List<EngineermeasurementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }
}

