/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementPayeeDetailEntity;
import com.ejianc.business.middlemeasurement.mapper.EngineermeasurementMapper;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementPayeeDetailService;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineermeasurementService")
public class EngineermeasurementServiceImpl
extends BaseServiceImpl<EngineermeasurementMapper, EngineermeasurementEntity>
implements IEngineermeasurementService {
    @Autowired
    private IEngineermeasurementService service;
    @Autowired
    private IEngineermeasurementPayeeDetailService payeeDetailService;

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( reporting_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (EngineermeasurementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EngineermeasurementEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(EngineermeasurementEntity::getIsSettlement)).or()).eq(EngineermeasurementEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EngineermeasurementEntity::getProjectId, (Object)projectId)).ne(EngineermeasurementEntity::getBillState, (Object)3)).ne(EngineermeasurementEntity::getBillState, (Object)1)).apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }

    @Override
    public String updateSumData(Long projectId, Long contractId, Integer type) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        List engineermeasurementPayeeDetailEntities = this.payeeDetailService.list((Wrapper)lambda);
        Map<Object, Object> numInMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)engineermeasurementPayeeDetailEntities)) {
            numInMap = engineermeasurementPayeeDetailEntities.stream().filter(s -> s.getNowPaymentMny() != null).collect(Collectors.groupingBy(EngineermeasurementPayeeDetailEntity::getPid, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getNowPaymentMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(projectId != null, EngineermeasurementEntity::getProjectId, (Object)projectId);
        query.eq(contractId != null, EngineermeasurementEntity::getContractId, (Object)contractId);
        List engineermeasurementEntityList = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)engineermeasurementEntityList)) {
            for (EngineermeasurementEntity interimsettlementdetailEntity : engineermeasurementEntityList) {
                if (type == 1) {
                    BigDecimal currentCollection = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentCollection() != null).map(EngineermeasurementEntity::getCurrentCollection).reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeCollection(currentCollection);
                }
                if (type == 2) {
                    BigDecimal actualCompletedThisPeriod = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getActualCompletedThisPeriod() != null).map(EngineermeasurementEntity::getActualCompletedThisPeriod).reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeCompleted(actualCompletedThisPeriod);
                }
                if (type == 3) {
                    BigDecimal currentBatch = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentBatch() != null).map(EngineermeasurementEntity::getCurrentBatch).reduce(BigDecimal.ZERO, BigDecimal::add);
                    interimsettlementdetailEntity.setCumulativeBatch(currentBatch);
                }
                if (type != 4) continue;
                BigDecimal currentReceivables = engineermeasurementEntityList.stream().filter(s -> s.getId() <= interimsettlementdetailEntity.getId() && s.getContractId().equals(interimsettlementdetailEntity.getContractId()) && s.getCurrentReceivables() != null).map(EngineermeasurementEntity::getCurrentReceivables).reduce(BigDecimal.ZERO, BigDecimal::add);
                interimsettlementdetailEntity.setAccumulatedContractualReceivables(currentReceivables);
            }
            this.service.updateBatchById(engineermeasurementEntityList);
        }
        return "";
    }
}

