/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.enums.OldFlagEnum;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.foundation.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchasesettlementExport"})
public class ExcelPurchasesettlementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IPurchasesettlementService purchasesettlementService;

    @RequestMapping(value={"/downloadPurchasesettlement"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchasesettlementdetail-import.xlsx", (String)"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPurchasesettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, Long contractId, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchasesettlementdetailVO> successList = new ArrayList<PurchasesettlementdetailVO>();
        ArrayList<PurchasesettlementdetailVO> errorList = new ArrayList<PurchasesettlementdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        LambdaQueryWrapper listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(PurchasesettlementEntity::getContractId, (Object)contractId);
        listWrapper.in(PurchasesettlementEntity::getBillState, new Object[]{1, 3});
        List purchasesettlementEntityList = this.purchasesettlementService.list((Wrapper)listWrapper);
        Map<Object, Object> groupMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)purchasesettlementEntityList)) {
            List ids = purchasesettlementEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper detailWrapper = Wrappers.lambdaQuery();
            detailWrapper.in(PurchasesettlementdetailEntity::getMid, ids);
            List mechanicalleasedetailEntityList = this.purchasesettlementdetailService.list((Wrapper)detailWrapper);
            if (CollectionUtils.isNotEmpty((Collection)mechanicalleasedetailEntityList)) {
                groupMap = mechanicalleasedetailEntityList.stream().collect(Collectors.groupingBy(s -> s.getBillCode()));
            }
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                int errorCount = 0;
                List datas = (List)result.get(i);
                PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                purchasesettlementdetailVO.setId(Long.valueOf(IdWorker.getId()));
                purchasesettlementdetailVO.setSource("\u5bfc\u5165");
                if (datas.get(0) == null && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u6750\u6599\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1))) && datas.get(1) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u6750\u6599\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2))) && datas.get(2) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u54c1\u724c/\u89c4\u683c\u578b\u53f7'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(0));
                if (back0.getCode() == 1 || back0.getData() == null) {
                    purchasesettlementdetailVO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u8be5\u6750\u6599\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getName()) && !((MaterialVO)back0.getData()).getName().equals(datas.get(1))) {
                    purchasesettlementdetailVO.setBillName(((MaterialVO)back0.getData()).getName());
                }
                purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                StringBuffer materConcat = new StringBuffer();
                if (datas.get(2) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materConcat.append(((MaterialVO)back0.getData()).getCode()).append(((MaterialVO)back0.getData()).getName()).append(((MaterialVO)back0.getData()).getSpec());
                }
                if (datas.get(3) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    materConcat.append(((MaterialVO)back0.getData()).getUnitName());
                }
                map.put(materConcat.toString(), materConcat.toString());
                purchasesettlementdetailVO.setBillCode(((MaterialVO)back0.getData()).getCode());
                purchasesettlementdetailVO.setBillName(((MaterialVO)back0.getData()).getName());
                purchasesettlementdetailVO.setBrandModel(((MaterialVO)back0.getData()).getSpec());
                purchasesettlementdetailVO.setUnit(((MaterialVO)back0.getData()).getUnitName());
                purchasesettlementdetailVO.setMaterialCategoryId(((MaterialVO)back0.getData()).getCategoryId());
                purchasesettlementdetailVO.setMaterialCategoryCode(((MaterialVO)back0.getData()).getCode());
                purchasesettlementdetailVO.setMaterialCategory(((MaterialVO)back0.getData()).getCategoryName());
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4))) || datas.get(4) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (DateUtils.grepDate((String)datas.get(4))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u65f6\u95f4'\u683c\u5f0f\u5230\u6708\u4efd");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? DateUtils.Dates((String)datas.get(4)) : null);
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5))) && datas.get(5) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(5)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u7f51\u4ef7'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setNetPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6))) && datas.get(6) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(6)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u6d6e\u52a8\u4ef7'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setFloatPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7))) && datas.get(7) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(7)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7\u9664\u7a0e(\u5143)'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8))) && datas.get(8) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(8)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7\u542b\u7a0e(\u5143)'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    }
                }
                BigDecimal supplyNumber = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9))) || datas.get(9) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(9)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u91cf'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    supplyNumber = supplyNumber.add(new BigDecimal((String)datas.get(9)));
                    purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                }
                BigDecimal exPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10))) || datas.get(10) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(10)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    exPrice = exPrice.add(new BigDecimal((String)datas.get(10)));
                    purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                }
                BigDecimal inPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11))) || datas.get(11) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(11)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    inPrice = inPrice.add(new BigDecimal((String)datas.get(11)));
                    purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                }
                purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? (String)datas.get(14) : null);
                String key = purchasesettlementdetailVO.getBillCode();
                BigDecimal settlementPrice = purchasesettlementdetailVO.getSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSettlementPrice();
                BigDecimal taxSettlementPrice = purchasesettlementdetailVO.getTaxSettlementPrice() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getTaxSettlementPrice();
                BigDecimal supplyQuantity = purchasesettlementdetailVO.getSupplyQuantity() == null ? BigDecimal.ZERO : purchasesettlementdetailVO.getSupplyQuantity();
                BigDecimal settlementAmount = settlementPrice.multiply(supplyQuantity);
                BigDecimal taxSettlementAmount = taxSettlementPrice.multiply(supplyQuantity);
                purchasesettlementdetailVO.setSettlementAmount(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmount);
                purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity);
                purchasesettlementdetailVO.setSettlementTotal(settlementAmount);
                purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount);
                this.logger.info("111");
                this.logger.info("111===" + key);
                if (groupMap.containsKey(key)) {
                    this.logger.info("222");
                    List groupList = (List)groupMap.get(key);
                    BigDecimal taxSettlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getTaxSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal settlementAmountSum = groupList.stream().map(PurchasesettlementdetailEntity::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal supplyQuantitySum = groupList.stream().map(PurchasesettlementdetailEntity::getSupplyQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    purchasesettlementdetailVO.setSettlementTotal(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setTaxSettlementTotal(taxSettlementAmount.add(taxSettlementAmountSum));
                    purchasesettlementdetailVO.setSupplyQuantityTotal(supplyQuantity.add(supplyQuantitySum));
                    purchasesettlementdetailVO.setSettleNum(supplyQuantity.add(supplyQuantitySum));
                    purchasesettlementdetailVO.setSettleMny(settlementAmount.add(settlementAmountSum));
                    purchasesettlementdetailVO.setSettleMnyTax(taxSettlementAmount.add(taxSettlementAmountSum));
                }
                if (errorCount != 0) continue;
                successList.add(purchasesettlementdetailVO);
            }
        }
        this.getLastDetail(contractId, successList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private void getLastDetail(Long contractId, List<PurchasesettlementdetailVO> successList) {
        String key;
        LambdaQueryWrapper lambdaLast = Wrappers.lambdaQuery();
        lambdaLast.eq(PurchasesettlementEntity::getContractId, (Object)contractId);
        lambdaLast.in(PurchasesettlementEntity::getBillState, new Object[]{1, 3});
        lambdaLast.orderByDesc(BaseEntity::getCreateTime);
        List costanalysisEntityList = this.purchasesettlementService.list((Wrapper)lambdaLast);
        List subcontractingvolumedetailEntityList = new ArrayList();
        Map<Object, Object> groupMap = new HashMap();
        Map<Object, Object> groupLastMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)costanalysisEntityList)) {
            PurchasesettlementEntity subcontractingvolumeEntityLast = (PurchasesettlementEntity)((Object)costanalysisEntityList.stream().findFirst().get());
            LambdaQueryWrapper lambdaCostPeople = Wrappers.lambdaQuery();
            lambdaCostPeople.eq(PurchasesettlementdetailEntity::getMid, (Object)subcontractingvolumeEntityLast.getId());
            subcontractingvolumedetailEntityList = this.purchasesettlementdetailService.list((Wrapper)lambdaCostPeople);
        }
        groupMap = successList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(s -> s.getBillCode()));
        List subcontractingvolumedetailVOS = BeanMapper.mapList(subcontractingvolumedetailEntityList, PurchasesettlementdetailVO.class);
        for (PurchasesettlementdetailVO subcontractingvolumedetailEntity : subcontractingvolumedetailVOS) {
            key = subcontractingvolumedetailEntity.getBillCode();
            if (groupMap.containsKey(key)) continue;
            subcontractingvolumedetailEntity.setSupplyQuantity(BigDecimal.ZERO);
            subcontractingvolumedetailEntity.setSettlementAmount(BigDecimal.ZERO);
            subcontractingvolumedetailEntity.setTaxSettlementAmount(BigDecimal.ZERO);
            subcontractingvolumedetailEntity.setId(Long.valueOf(IdWorker.getId()));
            subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.\u4e0a\u671f\u6570\u636e.getCode());
            subcontractingvolumedetailEntity.setMid(null);
            successList.add(subcontractingvolumedetailEntity);
        }
        groupLastMap = subcontractingvolumedetailVOS.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).collect(Collectors.groupingBy(s -> s.getBillCode()));
        for (PurchasesettlementdetailVO subcontractingvolumedetailEntity : successList) {
            key = subcontractingvolumedetailEntity.getBillCode();
            if (!groupLastMap.containsKey(key)) continue;
            subcontractingvolumedetailEntity.setOldFlag(OldFlagEnum.\u4e0a\u671f\u6570\u636e.getCode());
        }
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)purchasesettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.purchasesettlementdetailService.list((Wrapper)queryWrapper);
        List purchasesettlementdetailVOList = BeanMapper.mapList((Iterable)list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = (PurchasesettlementdetailVO)purchasesettlementdetailVOList.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                String sdates = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                purchasesettlementdetailVO.setSupplyTimeShow(sdates);
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                String sdate = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                purchasesettlementdetailVO.setSupplyTimeShow(sdate);
            }
        }
        HashMap<String, List<PurchasesettlementdetailVO>> beans = new HashMap<String, List<PurchasesettlementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }
}

