package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 甲方客户需求-需求明细
 * 
 * @author generator
 * 
 */
public class CustomerDemandDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long businessTypeId; // 业务类型id
    private String businessTypeName; // 业务类型名称
    private Long nodeId; // 节点id
    private String nodeName; // 节点名称
    private Long demandExplainId; // 需求描述id
    private String demandExplainName; // 需求描述名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date hopeFinishDate; // 期望完成日期
    private String commitUser; // 提出人
    private String commitUserDepartment; // 提出部门
    private String progress; // 进展
    private Integer detailState; // 状态(0:关闭，1：进行中，2：不处理)
    private Long demandId; // 甲方客户需求id

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBusinessTypeId() {
        return businessTypeId;
    }
    @ReferDeserialTransfer
    public void setBusinessTypeId(Long businessTypeId) {
        this.businessTypeId = businessTypeId;
    }
    public String getBusinessTypeName() {
        return businessTypeName;
    }

    public void setBusinessTypeName(String businessTypeName) {
        this.businessTypeName = businessTypeName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getNodeId() {
        return nodeId;
    }
    @ReferDeserialTransfer
    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }
    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getDemandExplainId() {
        return demandExplainId;
    }
    @ReferDeserialTransfer
    public void setDemandExplainId(Long demandExplainId) {
        this.demandExplainId = demandExplainId;
    }
    public String getDemandExplainName() {
        return demandExplainName;
    }

    public void setDemandExplainName(String demandExplainName) {
        this.demandExplainName = demandExplainName;
    }
    public Date getHopeFinishDate() {
        return hopeFinishDate;
    }

    public void setHopeFinishDate(Date hopeFinishDate) {
        this.hopeFinishDate = hopeFinishDate;
    }
    public String getCommitUser() {
        return commitUser;
    }

    public void setCommitUser(String commitUser) {
        this.commitUser = commitUser;
    }
    public String getCommitUserDepartment() {
        return commitUserDepartment;
    }

    public void setCommitUserDepartment(String commitUserDepartment) {
        this.commitUserDepartment = commitUserDepartment;
    }
    public String getProgress() {
        return progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public Integer getDetailState() {
        return detailState;
    }

    public void setDetailState(Integer detailState) {
        this.detailState = detailState;
    }

    public Long getDemandId() {
        return demandId;
    }

    public void setDemandId(Long demandId) {
        this.demandId = demandId;
    }
    
}
