package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 证件管理档案
 *
 * @author generator
 *
 */
public class ManagementVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.Long orgId; // 所属组织
    private java.lang.String orgName; // 组织名称
    private java.lang.Integer personalType; // 人员类别(0-内部，1-外部)
    private java.lang.String personalTypeName; // 人员类别名称(0-内部，1-外部)
    private java.lang.String name; // 姓名
    private java.lang.String telephone; // 联系电话
    private java.lang.Integer sex; // 性别(0-男，1-女)
    private java.lang.String idNumber; // 身份证号
    private java.lang.String educationCode; // 学历编码
    private java.lang.String major; // 专业
    private java.lang.Integer type; // 类型(0-个人证照，1-企业证照)
    private java.lang.String typeName;
    private java.lang.Long certTypeId; // 证照类别
    private String certTypeName;  // 证照类别名称
    private java.lang.String certName; // 证照名称
    private java.lang.String certCode; // 证照编号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date effectiveDate; // 生效时间
    private java.lang.Integer isTerm; // 有无期限(0-有，1-长期有效)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date failureDate; // 失效时间
    private java.lang.String failureDateName;
    private java.lang.Long certStatus; // 证书使用状态
    private java.lang.String certStatusName; // 证书使用状态
    private java.lang.Integer stockStatus; // 库存状态(0-在册，1-借出)
    private java.lang.String stockStatusName;
    private java.lang.String office; // 发证机关
    private java.lang.String storageLocation; // 存放地点
    private java.lang.String memo; // 备注
    private java.lang.String effectiveTerm; // 有效期限
    private java.lang.Integer termStatus; // 到期状态(0-正常，1-即将到期，2-到期)
    private java.lang.String exprieName;

    private java.lang.Long exprieDay; //剩余过期天数

    private Long userId; // 人员id，内部人员时
    private String registCertNumber; // 注册证号
    private String certMajor; // 证书专业
    private String certLevel; // 证书等级
    private String sealMajor; // 印章专业
    private String approvalNumber; // 批准文号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date issuanceDate; // 发证日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date addExpirationDate; // 加注有效期至
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date sealUntilDate; // 印章有效期至

    public String getEducationCode() {
        return educationCode;
    }

    public void setEducationCode(String educationCode) {
        this.educationCode = educationCode;
    }

    public Long getExprieDay() {
        return exprieDay;
    }

    public void setExprieDay(Long exprieDay) {
        this.exprieDay = exprieDay;
    }

    public String getCertLevel() {
        return certLevel;
    }

    public void setCertLevel(String certLevel) {
        this.certLevel = certLevel;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getUserId() {
        return userId;
    }
    @ReferDeserialTransfer
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getRegistCertNumber() {
        return registCertNumber;
    }

    public void setRegistCertNumber(String registCertNumber) {
        this.registCertNumber = registCertNumber;
    }

    public String getCertMajor() {
        return certMajor;
    }

    public void setCertMajor(String certMajor) {
        this.certMajor = certMajor;
    }

    public String getSealMajor() {
        return sealMajor;
    }

    public void setSealMajor(String sealMajor) {
        this.sealMajor = sealMajor;
    }

    public String getApprovalNumber() {
        return approvalNumber;
    }

    public void setApprovalNumber(String approvalNumber) {
        this.approvalNumber = approvalNumber;
    }

    public Date getIssuanceDate() {
        return issuanceDate;
    }

    public void setIssuanceDate(Date issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public Date getAddExpirationDate() {
        return addExpirationDate;
    }

    public void setAddExpirationDate(Date addExpirationDate) {
        this.addExpirationDate = addExpirationDate;
    }

    public Date getSealUntilDate() {
        return sealUntilDate;
    }

    public void setSealUntilDate(Date sealUntilDate) {
        this.sealUntilDate = sealUntilDate;
    }


    public String getCertStatusName() {
        return certStatusName;
    }

    public void setCertStatusName(String certStatusName) {
        this.certStatusName = certStatusName;
    }

    public String getExprieName() {
        return exprieName;
    }

    public void setExprieName(String exprieName) {
        this.exprieName = exprieName;
    }

    public String getPersonalTypeName() {
        return personalTypeName;
    }

    public void setPersonalTypeName(String personalTypeName) {
        this.personalTypeName = personalTypeName;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getStockStatusName() {
        return stockStatusName;
    }

    public void setStockStatusName(String stockStatusName) {
        this.stockStatusName = stockStatusName;
    }

    public String getFailureDateName() {
        return failureDateName;
    }

    public void setFailureDateName(String failureDateName) {
        this.failureDateName = failureDateName;
    }

    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    /**
     * 人员类别(0-内部，1-外部)
     */
    public java.lang.Integer getPersonalType() {
        return personalType;
    }

    /**
     * 人员类别(0-内部，1-外部)
     */
    public void setPersonalType(java.lang.Integer personalType) {
        this.personalType = personalType;
    }

    /**
     * 姓名
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 姓名
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 联系电话
     */
    public java.lang.String getTelephone() {
        return telephone;
    }

    /**
     * 联系电话
     */
    public void setTelephone(java.lang.String telephone) {
        this.telephone = telephone;
    }

    /**
     * 性别(0-男，1-女)
     */
    public java.lang.Integer getSex() {
        return sex;
    }

    /**
     * 性别(0-男，1-女)
     */
    public void setSex(java.lang.Integer sex) {
        this.sex = sex;
    }

    /**
     * 身份证号
     */
    public java.lang.String getIdNumber() {
        return idNumber;
    }

    /**
     * 身份证号
     */
    public void setIdNumber(java.lang.String idNumber) {
        this.idNumber = idNumber;
    }

    /**
     * 专业
     */
    public java.lang.String getMajor() {
        return major;
    }

    /**
     * 专业
     */
    public void setMajor(java.lang.String major) {
        this.major = major;
    }

    /**
     * 类型(0-个人证照，1-企业证照)
     */
    public java.lang.Integer getType() {
        return type;
    }

    /**
     * 类型(0-个人证照，1-企业证照)
     */
    public void setType(java.lang.Integer type) {
        this.type = type;
    }

    /**
     * 证照类别
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public java.lang.Long getCertTypeId() {
        return certTypeId;
    }

    /**
     * 证照类别
     */
    @ReferDeserialTransfer
    public void setCertTypeId(java.lang.Long certTypeId) {
        this.certTypeId = certTypeId;
    }

    /**
     * 证照名称
     */
    public java.lang.String getCertName() {
        return certName;
    }

    /**
     * 证照名称
     */
    public void setCertName(java.lang.String certName) {
        this.certName = certName;
    }

    /**
     * 证照编号
     */
    public java.lang.String getCertCode() {
        return certCode;
    }

    /**
     * 证照编号
     */
    public void setCertCode(java.lang.String certCode) {
        this.certCode = certCode;
    }

    /**
     * 生效时间
     */
    public java.util.Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效时间
     */
    public void setEffectiveDate(java.util.Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /**
     * 有无期限(0-有，1-长期有效)
     */
    public java.lang.Integer getIsTerm() {
        return isTerm;
    }

    /**
     * 有无期限(0-有，1-长期有效)
     */
    public void setIsTerm(java.lang.Integer isTerm) {
        this.isTerm = isTerm;
    }

    /**
     * 失效时间
     */
    public java.util.Date getFailureDate() {
        return failureDate;
    }

    /**
     * 失效时间
     */
    public void setFailureDate(java.util.Date failureDate) {
        this.failureDate = failureDate;
    }

    /**
     * 证书使用状态
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public java.lang.Long getCertStatus() {
        return certStatus;
    }

    /**
     * 证书使用状态
     */
    @ReferDeserialTransfer
    public void setCertStatus(java.lang.Long certStatus) {
        this.certStatus = certStatus;
    }

    /**
     * 库存状态(0-在册，1-借出)
     */
    public java.lang.Integer getStockStatus() {
        return stockStatus;
    }

    /**
     * 库存状态(0-在册，1-借出)
     */
    public void setStockStatus(java.lang.Integer stockStatus) {
        this.stockStatus = stockStatus;
    }

    /**
     * 发证机关
     */
    public java.lang.String getOffice() {
        return office;
    }

    /**
     * 发证机关
     */
    public void setOffice(java.lang.String office) {
        this.office = office;
    }

    /**
     * 存放地点
     */
    public java.lang.String getStorageLocation() {
        return storageLocation;
    }

    /**
     * 存放地点
     */
    public void setStorageLocation(java.lang.String storageLocation) {
        this.storageLocation = storageLocation;
    }

    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }

    /**
     * 有效期限
     */
    public java.lang.String getEffectiveTerm() {
        return effectiveTerm;
    }

    /**
     * 有效期限
     */
    public void setEffectiveTerm(java.lang.String effectiveTerm) {
        this.effectiveTerm = effectiveTerm;
    }

    /**
     * 到期状态(0-正常，1-即将到期，2-到期)
     */
    public java.lang.Integer getTermStatus() {
        return termStatus;
    }

    /**
     * 到期状态(0-正常，1-即将到期，2-到期)
     */
    public void setTermStatus(java.lang.Integer termStatus) {
        this.termStatus = termStatus;
    }

    public String getCertTypeName() {
        return certTypeName;
    }

    public void setCertTypeName(String certTypeName) {
        this.certTypeName = certTypeName;
    }
}
