package com.ejianc.business.oa.api;

import com.ejianc.business.oa.hystrix.OaHystrix;
import com.ejianc.business.oa.vo.AwardVO;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "ejc-oa-web", url = "${common.env.feign-client-url}", path = "ejc-oa-web", fallback = OaHystrix.class)
public interface IOaApi {
    /**
     * 查询投标文件评审子表 投标人员详情
     * @param opportunityId
     * @return
     */
    @RequestMapping(value = "/api/oa/queryBidDetailList", method = RequestMethod.GET)
    public CommonResponse<List<BidDetailVO>> queryBidDetailList(@RequestParam(value = "opportunityId") Long opportunityId);

    /**
     * 查询奖项管理
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/oa/queryAwardByProjectId", method = RequestMethod.GET)
    public CommonResponse<List<AwardVO>> queryAwardByProjectId(@RequestParam(value = "projectId") Long projectId);




}
