package com.ejianc.business.oa.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description: 学历枚举
 * @author songlx
 * @date 2024/4/19
 * @version 1.0
 */
public enum EducationCodeEnum {

    小学("xiaoxue", "小学"),

    初中("chuzhong", "初中"),

    中专_高中("gaozhong", "中专/高中"),

    专科("zhuanke", "专科"),

    本科("benke", "本科"),

    硕士研究生("shuoshi", "硕士研究生"),

    博士("boshi", "博士"),

    无("wu", "无");

    private static Map<String, String> enumMap = new HashMap();

    static {
        enumMap = EnumSet.allOf(EducationCodeEnum.class).stream().collect(Collectors.toMap(EducationCodeEnum::getName, EducationCodeEnum::getCode));
    }


    public static String getCodeByName(String name) {
        return enumMap.get(name) != null ? enumMap.get(name) : 无.getCode();
    }


    private String code;

    private String name;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    EducationCodeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }
}
