package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 投标文件评审实体
 *
 * @author generator
 *
 */
public class BidVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long opportunityId; // 工程主键
    private String opportunityName; // 工程名称
    private Long engineeringType; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    private Long employeeId; // 项目经理主键
    private String employeeName; // 项目经理
    private BigDecimal offerMny; // 报价
    private BigDecimal bondMny; // 投标保证金
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bidDate; // 开标日期
    private BigDecimal bidMny; // 投标金额
    private String content; // 投标内容
    private Integer billState; // 单据状态
    private String fileUrls; // 投标文件
    private Long orgId; // 所属组织
    private String orgName; // 组织名称
    private Long makerId; // 编制人主键
    private String makerName; // 编制人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate;
    private BigDecimal highestMny; // 最高限价

    private  Long techManage; // 技术负责人
    private  String techManageName; // 技术负责人

    private List<BidDetailVO> detailList = new ArrayList<>(); // 投标文件评审子实体
    private List<BidProjectVO> projectVOList = new ArrayList<>(); // 项目业绩选择
    private List<BidRequireVO> requireVOList = new ArrayList<>(); // 招标文件要求

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程主键
     */
    @ReferSerialTransfer(referCode="business-opportunity-register")
    public Long getOpportunityId() {
        return opportunityId;
    }

    /**
     * 工程主键
     */
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    /**
     * 工程名称
     */
    public String getOpportunityName() {
        return opportunityName;
    }

    public List<BidProjectVO> getProjectVOList() {
        return projectVOList;
    }

    public void setProjectVOList(List<BidProjectVO> projectVOList) {
        this.projectVOList = projectVOList;
    }

    public List<BidRequireVO> getRequireVOList() {
        return requireVOList;
    }

    public void setRequireVOList(List<BidRequireVO> requireVOList) {
        this.requireVOList = requireVOList;
    }

    /**
     * 工程名称
     */
    public void setOpportunityName(String opportunityName) {
        this.opportunityName = opportunityName;
    }
    /**
     * 工程类型
     */
    public Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类型
     */
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类型名称
     */
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getTechManage() {
        return techManage;
    }
    @ReferDeserialTransfer
    public void setTechManage(Long techManage) {
        this.techManage = techManage;
    }

    public String getTechManageName() {
        return techManageName;
    }

    public void setTechManageName(String techManageName) {
        this.techManageName = techManageName;
    }
    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 项目经理主键
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 项目经理主键
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 项目经理
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 项目经理
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 报价
     */
    public BigDecimal getOfferMny() {
        return offerMny;
    }

    /**
     * 报价
     */
    public void setOfferMny(BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    /**
     * 投标保证金
     */
    public BigDecimal getBondMny() {
        return bondMny;
    }

    /**
     * 投标保证金
     */
    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    /**
     * 开标日期
     */
    public Date getBidDate() {
        return bidDate;
    }

    /**
     * 开标日期
     */
    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    /**
     * 投标金额
     */
    public BigDecimal getBidMny() {
        return bidMny;
    }

    /**
     * 投标金额
     */
    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    /**
     * 投标内容
     */
    public String getContent() {
        return content;
    }

    /**
     * 投标内容
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 投标文件
     */
    public String getFileUrls() {
        return fileUrls;
    }

    /**
     * 投标文件
     */
    public void setFileUrls(String fileUrls) {
        this.fileUrls = fileUrls;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 编制人主键
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMakerId() {
        return makerId;
    }

    /**
     * 编制人主键
     */
    @ReferDeserialTransfer
    public void setMakerId(Long makerId) {
        this.makerId = makerId;
    }
    /**
     * 编制人名称
     */
    public String getMakerName() {
        return makerName;
    }

    /**
     * 编制人名称
     */
    public void setMakerName(String makerName) {
        this.makerName = makerName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public BigDecimal getHighestMny() {
        return highestMny;
    }

    public void setHighestMny(BigDecimal highestMny) {
        this.highestMny = highestMny;
    }

    public List<BidDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BidDetailVO> detailList) {
        this.detailList = detailList;
    }
}
