package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 收发文实体
 * 
 * @author generator
 * 
 */
public class PostingVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 文号
    private Long postingTypeId; // 文件类型(1-红头文件,2-其他文件)
    private String postingTypeName; // 文件类型名称
    private Long projectId; // 涉及项目
    private String projectName; // 项目名称
    private String projectCode; // 项目code
    private String postingName; // 文件名称
    private Integer postingForm; // 文件形式(1-收文,2-发文)
    private String postingFormName; // 文件形式(1-收文,2-发文)
    private BigDecimal postingNum; // 份数
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date dispatchDate; // 发文日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签收日期
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办人名称
    private Integer billState; // 单据状态（审批必须字段）
    private String memo; // 备注

    private Integer replyFlag; // 是否回函1是0否

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date replyDate; // 回函时间

    public Integer getReplyFlag() {
        return replyFlag;
    }

    public void setReplyFlag(Integer replyFlag) {
        this.replyFlag = replyFlag;
    }

    public Date getReplyDate() {
        return replyDate;
    }

    public void setReplyDate(Date replyDate) {
        this.replyDate = replyDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPostingTypeId() {
        return postingTypeId;
    }

    @ReferDeserialTransfer
    public void setPostingTypeId(Long postingTypeId) {
        this.postingTypeId = postingTypeId;
    }
    public String getPostingTypeName() {
        return postingTypeName;
    }

    public void setPostingTypeName(String postingTypeName) {
        this.postingTypeName = postingTypeName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getPostingName() {
        return postingName;
    }

    public void setPostingName(String postingName) {
        this.postingName = postingName;
    }
    public Integer getPostingForm() {
        return postingForm;
    }
    public void setPostingForm(Integer postingForm) {
        this.postingForm = postingForm;
    }
    public BigDecimal getPostingNum() {
        return postingNum;
    }

    public String getPostingFormName() {
        return 1==postingForm?"收文":2==postingForm?"发文":null;
    }

    public void setPostingNum(BigDecimal postingNum) {
        this.postingNum = postingNum;
    }
    public Date getDispatchDate() {
        return dispatchDate;
    }

    public void setDispatchDate(Date dispatchDate) {
        this.dispatchDate = dispatchDate;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferSerialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferSerialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
