package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 奖项实体
 *
 * @author generator
 */
public class AwardVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 证书编号
    private Long projectId; // 获奖项目
    private String projectName; // 获奖项目名称
    private String projectCode; // 获奖项目编码
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private String orgCode; // 组织code
    private String parentOrgName; // 父级组织名称
    private String parentOrgCode; // 父级组织编码
    private Long parentOrgId; // 父级组织
    private String employeeId; // 获奖人员Id
    private String employeeName; // 获奖人员姓名
    private String awardName; // 获奖名称
    private Long awardRankingId; // 获奖等别
    private String awardRankingName; // 获奖等别名称
    private Long awardLevelId; // 获奖级别
    private String awardLevelName; // 获奖级别名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ratifyData; // 批准日期
    private String ratifyCode; // 批准文号
    private String awardAuthority; // 发证机关
    private String memo; // 其他

    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称

    private String validTerm; // 有无期限

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private String invalidDate; // 失效日期


    public String getValidTerm() {
        return validTerm;
    }

    public void setValidTerm(String validTerm) {
        this.validTerm = validTerm;
    }

    public String getInvalidDate() {
        return invalidDate;
    }

    public void setInvalidDate(String invalidDate) {
        this.invalidDate = invalidDate;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public String getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getAwardName() {
        return awardName;
    }

    public void setAwardName(String awardName) {
        this.awardName = awardName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAwardRankingId() {
        return awardRankingId;
    }

    @ReferDeserialTransfer
    public void setAwardRankingId(Long awardRankingId) {
        this.awardRankingId = awardRankingId;
    }

    public String getAwardRankingName() {
        return awardRankingName;
    }

    public void setAwardRankingName(String awardRankingName) {
        this.awardRankingName = awardRankingName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getAwardLevelId() {
        return awardLevelId;
    }

    @ReferDeserialTransfer
    public void setAwardLevelId(Long awardLevelId) {
        this.awardLevelId = awardLevelId;
    }

    public String getAwardLevelName() {
        return awardLevelName;
    }

    public void setAwardLevelName(String awardLevelName) {
        this.awardLevelName = awardLevelName;
    }

    public Date getRatifyData() {
        return ratifyData;
    }

    public void setRatifyData(Date ratifyData) {
        this.ratifyData = ratifyData;
    }

    public String getRatifyCode() {
        return ratifyCode;
    }

    public void setRatifyCode(String ratifyCode) {
        this.ratifyCode = ratifyCode;
    }

    public String getAwardAuthority() {
        return awardAuthority;
    }

    public void setAwardAuthority(String awardAuthority) {
        this.awardAuthority = awardAuthority;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}