package com.ejianc.business.oa.service.impl;

import com.ejianc.business.oa.vo.SealApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.SealApplyMapper;
import com.ejianc.business.oa.bean.SealApplyEntity;
import com.ejianc.business.oa.service.ISealApplyService;

/**
 * 用印申请实体
 * 
 * @author generator
 * 
 */
@Service("sealApplyService")
public class SealApplyServiceImpl extends BaseServiceImpl<SealApplyMapper, SealApplyEntity> implements ISealApplyService{
    private static final String BILL_CODE = "seal-use-code001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public SealApplyVO insertOrUpdate(SealApplyVO saveorUpdateVO) {
        SealApplyEntity entity = BeanMapper.map(saveorUpdateVO, SealApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdateNoES(entity);
        SealApplyVO vo = BeanMapper.map(entity, SealApplyVO.class);
        return vo;
    }

    @Override
    public SealApplyVO queryDetail(Long id) {
        SealApplyEntity entity = this.selectById(id);
        SealApplyVO vo = BeanMapper.map(entity, SealApplyVO.class);
        return vo;
    }
}
