package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 周报
 *
 * @author generator
 */
@Controller
@RequestMapping("weeklyReport")
public class WeeklyReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWeeklyReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> saveOrUpdate(@RequestBody WeeklyReportVO weeklyReportVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(weeklyReportVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> queryDetail(Long id) {
        WeeklyReportEntity entity = service.selectById(id);
        WeeklyReportVO vo = BeanMapper.map(entity, WeeklyReportVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param projectId
     * @Description afterProject 项目编辑后
     */
    @RequestMapping(value = "/afterProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> afterProject(@RequestParam(value = "id", required = false) Long id, @RequestParam(value = "projectId") Long projectId,
                                                       @RequestParam(value = "weeklyNum", required = false) Integer weeklyNum) {
        return CommonResponse.success("查询项目编辑后数据成功！", service.afterProject(id, projectId, weeklyNum));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeeklyReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WeeklyReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WeeklyReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<WeeklyReportEntity> page = service.queryPage(param, false);
        IPage<WeeklyReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeeklyReportVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WeeklyReportVO>> commonResponse = queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<WeeklyReportVO> records = commonResponse.getData().getRecords();
        records.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("WeeklyReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWeeklyReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> refWeeklyReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WeeklyReportEntity> page = service.queryPage(param, false);
        IPage<WeeklyReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeeklyReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryReportList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询周报报表成功!", service.queryReportList(param));
    }

    @RequestMapping(value = "excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(-1);
        param.setPageIndex(1);
        CommonResponse<IPage<WeeklyReportVO>> voPage = queryReportList(param);
        List<WeeklyReportVO> list = voPage.getData().getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        /** 冻结前三行 */
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 15));

        //首行标题
        XSSFRow row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        style.setBorderLeft((short) 1);
        style.setBorderRight((short) 1);
        style.setBorderBottom((short) 1);
        style.setBorderTop((short) 1);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("预算报表");
        cell.setCellStyle(style);
        for (int i = 1; i < 16; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
        }
        //第二行数据
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("项目总监");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("单据编号");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("项目名称");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("项目金额(万元)");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("第几周");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("上周进度(%)");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("本周进度(%)");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("预计实际完工时间");
        cell.setCellStyle(style);
        cell = row.createCell(8);
        cell.setCellValue("项目经理");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("预计总成本(万元)");
        cell.setCellStyle(style);
        cell = row.createCell(10);
        cell.setCellValue("本周完成产值(万元)");
        cell.setCellStyle(style);
        cell = row.createCell(11);
        cell.setCellValue("区域每周产值(万元）");
        cell.setCellStyle(style);
        cell = row.createCell(12);
        cell.setCellValue("区域每周平均人效");
        cell.setCellStyle(style);
        cell = row.createCell(13);
        cell.setCellValue("项目人效");
        cell.setCellStyle(style);
        cell = row.createCell(14);
        cell.setCellValue("施工人数");
        cell.setCellStyle(style);
        cell = row.createCell(15);
        cell.setCellStyle(style);
        cell.setCellValue("管理人员");

        for (int i = 0; i < 13; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 13);
        }
        for (int i = 0; i < list.size(); i++) {
            WeeklyReportVO vo = list.get(i);
            row = sheet.createRow(i + 2);
            if (vo.getRowSpan() > 0) {
                Integer rowSpan = vo.getRowSpan();
                cell = row.createCell(0);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));

                cell = row.createCell(11);
                cell.setCellValue(vo.getAreaOutputMny() == null ? "" : vo.getAreaOutputMny().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 11, 11));

                cell = row.createCell(12);
                cell.setCellValue(vo.getAreaPersonEfficiency() == null ? "" : vo.getAreaPersonEfficiency().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 12, 12));
            }
            if (vo.getNormalRowSpan() > 0) {
                Integer rowSpan = vo.getNormalRowSpan();
                cell = row.createCell(1);
                cell.setCellValue(vo.getBillCode() == null ? "" : vo.getBillCode());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));

                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));

                cell = row.createCell(3);
                cell.setCellValue(vo.getCostTotalMny() == null ? "" : vo.getCostTotalMny().setScale(2).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));

                cell = row.createCell(4);
                cell.setCellValue(vo.getWeeklyNum() == null ? "" : vo.getWeeklyNum().toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(5);
                cell.setCellValue(vo.getLastWeeklyProgress() == null ? "" : vo.getLastWeeklyProgress().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 5, 5));

                cell = row.createCell(6);
                cell.setCellValue(vo.getWeeklyProgress() == null ? "" : vo.getWeeklyProgress().setScale(2).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 6, 6));

                cell = row.createCell(7);
                cell.setCellValue(vo.getPreFinishDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(vo.getPreFinishDate()));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 7, 7));

                cell = row.createCell(8);
                cell.setCellValue(vo.getProjectManagerName() == null ? "" : vo.getProjectManagerName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 8, 8));

                cell = row.createCell(9);
                cell.setCellValue(vo.getPreCostMny() == null ? "" : vo.getPreCostMny().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 9, 9));

                cell = row.createCell(10);
                cell.setCellValue(vo.getFinishOutputMny() == null ? "" : vo.getFinishOutputMny().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 10, 10));

                cell = row.createCell(13);
                cell.setCellValue(vo.getProjPersonEfficiency() == null ? "" : vo.getProjPersonEfficiency().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 13, 13));

                cell = row.createCell(14);
                cell.setCellValue(vo.getConstructionPersonNum() == null ? "" : vo.getConstructionPersonNum().setScale(0, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 14, 14));

                cell = row.createCell(15);
                cell.setCellValue(vo.getManagePersonNum() == null ? "" : vo.getManagePersonNum().setScale(0, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 15, 15));
            }
        }
        workbook.write(outputStream);
    }


    @RequestMapping(value = "queryProblemList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryProblemList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询周问题报表成功!", service.queryProblemList(param));
    }

    @RequestMapping(value = "excelExportProblem", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportProblem(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(-1);
        param.setPageIndex(1);
        CommonResponse<IPage<WeeklyReportVO>> voPage = queryProblemList(param);
        List<WeeklyReportVO> list = voPage.getData().getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        /** 冻结前三行 */
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 2));

        //首行标题
        XSSFRow row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        style.setBorderLeft((short) 1);
        style.setBorderRight((short) 1);
        style.setBorderBottom((short) 1);
        style.setBorderTop((short) 1);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("预算报表");
        cell.setCellStyle(style);
        for (int i = 1; i < 3; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
        }
        //第二行数据
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("区域");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("项目名称");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("第几周");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("本周问题");
        cell.setCellStyle(style);

        for (int i = 0; i < 4; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 4);
        }
        for (int i = 0; i < list.size(); i++) {
            WeeklyReportVO vo = list.get(i);
            row = sheet.createRow(i + 2);
            if (vo.getRowSpan() > 0) {
                Integer rowSpan = vo.getRowSpan();
                cell = row.createCell(0);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));
            }
            if (vo.getNormalRowSpan() > 0) {
                Integer rowSpan = vo.getNormalRowSpan();
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));

                cell = row.createCell(2);
                cell.setCellValue(vo.getWeeklyNum() == null ? "" : String.valueOf(vo.getWeeklyNum().intValue()));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));

                cell = row.createCell(3);
                cell.setCellValue(vo.getWeeklyProblem() == null ? "" : vo.getWeeklyProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            }
        }
        workbook.write(outputStream);
    }
}
