package com.ejianc.business.oa.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/weeklyReport/")
public class WeeklyReportApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWeeklyReportService weeklyReportService;

    /**
     *
     * @return
     */
    @RequestMapping(value = "queryLatest", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> queryLatest(@RequestParam(value = "projectId") Long projectId) {
        LambdaQueryWrapper<WeeklyReportEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WeeklyReportEntity::getProjectId, projectId);
        queryWrapper.in(WeeklyReportEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(WeeklyReportEntity::getWeeklyNum);
        queryWrapper.last("limit 1");
        WeeklyReportEntity reportEntity = weeklyReportService.getOne(queryWrapper, false);
        return CommonResponse.success("查询成功！", null != reportEntity ? BeanMapper.map(reportEntity, WeeklyReportVO.class) : null);
    }
}
