/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"weeklyReport"})
public class WeeklyReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWeeklyReportService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WeeklyReportVO> saveOrUpdate(@RequestBody WeeklyReportVO weeklyReportVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(weeklyReportVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeeklyReportVO> queryDetail(Long id) {
        WeeklyReportEntity entity = (WeeklyReportEntity)((Object)this.service.selectById(id));
        WeeklyReportVO vo = (WeeklyReportVO)BeanMapper.map((Object)((Object)entity), WeeklyReportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/afterProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WeeklyReportVO> afterProject(@RequestParam(value="id", required=false) Long id, @RequestParam(value="projectId") Long projectId, @RequestParam(value="weeklyNum", required=false) Integer weeklyNum) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u7f16\u8f91\u540e\u6570\u636e\u6210\u529f\uff01", (Object)this.service.afterProject(id, projectId, weeklyNum));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeeklyReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WeeklyReportVO weeklyReportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeeklyReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WeeklyReportVO>> commonResponse = this.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List records = ((IPage)commonResponse.getData()).getRecords();
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", records);
        ExcelExport.getInstance().export("WeeklyReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWeeklyReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> refWeeklyReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WeeklyReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryReportList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5468\u62a5\u62a5\u8868\u6210\u529f!", this.service.queryReportList(param));
    }

    @RequestMapping(value={"excelExportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        int i;
        param.setPageSize(-1);
        param.setPageIndex(1);
        CommonResponse<IPage<WeeklyReportVO>> voPage = this.queryReportList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 16));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        XSSFCell cell = row.createCell(0);
        Map params = param.getParams();
        Parameter weeklyNum = (Parameter)params.get("weeklyNum");
        cell.setCellValue("\u65bd\u5de5\u5468\u62a5" + (weeklyNum != null ? "\uff08\u7b2c" + weeklyNum.getValue().toString() + "\u5468\uff09" : ""));
        cell.setCellStyle((CellStyle)style);
        for (i = 1; i < 17; ++i) {
            cell = row.createCell(i);
            cell.setCellStyle((CellStyle)style);
        }
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("\u5e8f\u53f7");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(1);
        cell.setCellValue("\u9879\u76ee\u603b\u76d1");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellValue("\u5355\u636e\u7f16\u53f7");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(3);
        cell.setCellValue("\u9879\u76ee\u7f16\u7801");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(4);
        cell.setCellValue("\u9879\u76ee\u540d\u79f0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(5);
        cell.setCellValue("\u5408\u540c\u603b\u91d1\u989d(\u4e07\u5143)");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(6);
        cell.setCellValue("\u7b2c\u51e0\u5468");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(7);
        cell.setCellValue("\u4e0a\u5468\u8fdb\u5ea6(%)");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(8);
        cell.setCellValue("\u672c\u5468\u8fdb\u5ea6(%)");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(9);
        cell.setCellValue("\u9884\u8ba1\u5b9e\u9645\u5b8c\u5de5\u65f6\u95f4");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(10);
        cell.setCellValue("\u9879\u76ee\u7ecf\u7406");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(11);
        cell.setCellValue("\u672c\u5468\u5b8c\u6210\u4ea7\u503c(\u4e07\u5143)");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(12);
        cell.setCellValue("\u533a\u57df\u6bcf\u5468\u4ea7\u503c(\u4e07\u5143\uff09");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(13);
        cell.setCellValue("\u533a\u57df\u6bcf\u5468\u5e73\u5747\u4eba\u6548");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(14);
        cell.setCellValue("\u9879\u76ee\u4eba\u6548");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(15);
        cell.setCellValue("\u65bd\u5de5\u4eba\u6570");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(16);
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue("\u7ba1\u7406\u4eba\u5458");
        for (i = 0; i < 13; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 13);
        }
        for (i = 0; i < list.size(); ++i) {
            Integer rowSpan;
            WeeklyReportVO vo = (WeeklyReportVO)list.get(i);
            row = sheet.createRow(i + 2);
            if (vo.getRowSpan() > 0) {
                rowSpan = vo.getRowSpan();
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));
                cell = row.createCell(12);
                cell.setCellValue(vo.getAreaOutputMny() == null ? "" : vo.getAreaOutputMny().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 12, 12));
                cell = row.createCell(13);
                cell.setCellValue(vo.getAreaPersonEfficiency() == null ? "" : vo.getAreaPersonEfficiency().setScale(2, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 13, 13));
            }
            if (vo.getNormalRowSpan() <= 0) continue;
            rowSpan = vo.getNormalRowSpan();
            cell = row.createCell(0);
            cell.setCellValue(i + 1 + "");
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));
            cell = row.createCell(2);
            cell.setCellValue(vo.getBillCode() == null ? "" : vo.getBillCode());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));
            cell = row.createCell(3);
            cell.setCellValue(vo.getProjectCode() == null ? "" : vo.getProjectCode());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(4);
            cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(5);
            cell.setCellValue(vo.getCostTotalMny() == null ? "" : vo.getCostTotalMny().setScale(2, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 5, 5));
            cell = row.createCell(6);
            cell.setCellValue(vo.getWeeklyNum() == null ? "" : vo.getWeeklyNum().toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 6, 6));
            cell = row.createCell(7);
            cell.setCellValue(vo.getLastWeeklyProgress() == null ? "" : vo.getLastWeeklyProgress().setScale(2, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 7, 7));
            cell = row.createCell(8);
            cell.setCellValue(vo.getWeeklyProgress() == null ? "" : vo.getWeeklyProgress().setScale(2, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 8, 8));
            cell = row.createCell(9);
            cell.setCellValue(vo.getPreFinishDate() == null ? "" : new SimpleDateFormat("yyyy-MM-dd").format(vo.getPreFinishDate()));
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 9, 9));
            cell = row.createCell(10);
            cell.setCellValue(vo.getProjectManagerName() == null ? "" : vo.getProjectManagerName());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 10, 10));
            cell = row.createCell(11);
            cell.setCellValue(vo.getFinishOutputMny() == null ? "" : vo.getFinishOutputMny().setScale(2, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 11, 11));
            cell = row.createCell(14);
            cell.setCellValue(vo.getProjPersonEfficiency() == null ? "" : vo.getProjPersonEfficiency().setScale(2, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 14, 14));
            cell = row.createCell(15);
            cell.setCellValue(vo.getConstructionPersonNum() == null ? "" : vo.getConstructionPersonNum().setScale(0, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 15, 15));
            cell = row.createCell(16);
            cell.setCellValue(vo.getManagePersonNum() == null ? "" : vo.getManagePersonNum().setScale(0, RoundingMode.HALF_UP).toString());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 16, 16));
        }
        workbook.write((OutputStream)outputStream);
    }

    @RequestMapping(value={"queryProblemList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryProblemList(@RequestBody QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("projectDirectorName", "projectCode", "projectName"));
        return CommonResponse.success((String)"\u67e5\u8be2\u5468\u95ee\u9898\u62a5\u8868\u6210\u529f!", this.service.queryProblemList(param));
    }

    @RequestMapping(value={"excelExportProblem"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportProblem(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        int i;
        param.setPageSize(-1);
        param.setPageIndex(1);
        param.getFuzzyFields().addAll(Arrays.asList("projectDirectorName", "projectCode", "projectName"));
        CommonResponse<IPage<WeeklyReportVO>> voPage = this.queryProblemList(param);
        List list = ((IPage)voPage.getData()).getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 15));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        XSSFCell cell = row.createCell(0);
        Map params = param.getParams();
        Parameter weeklyNum = (Parameter)params.get("weeklyNum");
        cell.setCellValue("\u5468\u95ee\u9898\u62a5\u8868" + (weeklyNum != null ? "\uff08\u7b2c" + weeklyNum.getValue().toString() + "\u5468\uff09" : ""));
        cell.setCellStyle((CellStyle)style);
        for (i = 1; i < 16; ++i) {
            cell = row.createCell(i);
            cell.setCellStyle((CellStyle)style);
        }
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("\u533a\u57df");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(1);
        cell.setCellValue("\u9879\u76ee\u7f16\u7801");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(2);
        cell.setCellValue("\u9879\u76ee\u540d\u79f0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(3);
        cell.setCellValue("\u7b2c\u51e0\u5468");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(4);
        cell.setCellValue("\u7269\u6599\u65b9\u9762\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(5);
        cell.setCellValue("\u7269\u6599\u65b9\u9762\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(6);
        cell.setCellValue("\u73ed\u7ec4\u65b9\u9762\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(7);
        cell.setCellValue("\u73ed\u7ec4\u65b9\u9762\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(8);
        cell.setCellValue("\u6837\u677f\u95f4\u65bd\u5de5\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(9);
        cell.setCellValue("\u6837\u677f\u95f4\u65bd\u5de5\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(10);
        cell.setCellValue("\u73b0\u573a\u65b9\u6848\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(11);
        cell.setCellValue("\u73b0\u573a\u65b9\u6848\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(12);
        cell.setCellValue("\u5408\u540c\u65b9\u9762\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(13);
        cell.setCellValue("\u5408\u540c\u65b9\u9762\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(14);
        cell.setCellValue("\u5176\u4ed6\u95ee\u9898\u63cf\u8ff0");
        cell.setCellStyle((CellStyle)style);
        cell = row.createCell(15);
        cell.setCellValue("\u5176\u4ed6\u95ee\u9898\u63aa\u65bd");
        cell.setCellStyle((CellStyle)style);
        for (i = 0; i < 16; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 10 / 4);
        }
        for (i = 0; i < list.size(); ++i) {
            Integer rowSpan;
            WeeklyReportVO vo = (WeeklyReportVO)list.get(i);
            row = sheet.createRow(i + 2);
            if (vo.getRowSpan() > 0) {
                rowSpan = vo.getRowSpan();
                cell = row.createCell(0);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));
            }
            if (vo.getNormalRowSpan() <= 0) continue;
            rowSpan = vo.getNormalRowSpan();
            cell = row.createCell(1);
            cell.setCellValue(vo.getProjectCode() == null ? "" : vo.getProjectCode());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));
            cell = row.createCell(2);
            cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));
            cell = row.createCell(3);
            cell.setCellValue(vo.getWeeklyNum() == null ? "" : String.valueOf(vo.getWeeklyNum()));
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));
            cell = row.createCell(4);
            cell.setCellValue(vo.getMaterialProblem() == null ? "" : vo.getMaterialProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(5);
            cell.setCellValue(vo.getMaterialMeasure() == null ? "" : vo.getMaterialMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(6);
            cell.setCellValue(vo.getTeamProblem() == null ? "" : vo.getTeamProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(7);
            cell.setCellValue(vo.getTeamMeasure() == null ? "" : vo.getTeamMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(8);
            cell.setCellValue(vo.getRoomProblem() == null ? "" : vo.getRoomProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(9);
            cell.setCellValue(vo.getRoomMeasure() == null ? "" : vo.getRoomMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(10);
            cell.setCellValue(vo.getSceneProblem() == null ? "" : vo.getSceneProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(11);
            cell.setCellValue(vo.getSceneMeasure() == null ? "" : vo.getSceneMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(12);
            cell.setCellValue(vo.getContractProblem() == null ? "" : vo.getContractProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(13);
            cell.setCellValue(vo.getContractMeasure() == null ? "" : vo.getContractMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            cell = row.createCell(14);
            cell.setCellValue(vo.getOtherProblem() == null ? "" : vo.getOtherProblem());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
            cell = row.createCell(15);
            cell.setCellValue(vo.getOtherMeasure() == null ? "" : vo.getOtherMeasure());
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
        }
        workbook.write((OutputStream)outputStream);
    }
}

