/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.labor.api.IAttendanceApi;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.mapper.WeeklyReportMapper;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weeklyReportService")
public class WeeklyReportServiceImpl
extends BaseServiceImpl<WeeklyReportMapper, WeeklyReportEntity>
implements IWeeklyReportService {
    private static final String BILL_CODE = "WEEKLY_REPORT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttendanceApi attendanceApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IIncomeContractApi incomeContractApi;

    @Override
    public WeeklyReportVO saveOrUpdate(WeeklyReportVO weeklyReportVO) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WeeklyReportEntity::getProjectId, (Object)weeklyReportVO.getProjectId());
        queryWrapper.eq(WeeklyReportEntity::getWeeklyNum, (Object)weeklyReportVO.getWeeklyNum());
        queryWrapper.ne(null != weeklyReportVO.getId(), BaseEntity::getId, (Object)weeklyReportVO.getId());
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u5df2\u7ecf\u5b58\u5728\u672c\u5468\u5468\u62a5\uff0c\u8bf7\u8c03\u6574!");
        }
        WeeklyReportEntity entity = (WeeklyReportEntity)((Object)BeanMapper.map((Object)weeklyReportVO, WeeklyReportEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)weeklyReportVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (WeeklyReportVO)BeanMapper.map((Object)((Object)entity), WeeklyReportVO.class);
    }

    @Override
    public WeeklyReportVO afterProject(Long id, Long projectId, Integer weeklyNum) {
        CommonResponse contResponse;
        CommonResponse response;
        WeeklyReportVO reportVO = new WeeklyReportVO();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WeeklyReportEntity::getProjectId, (Object)projectId);
        queryWrapper.lt(null != weeklyNum && weeklyNum != 1, WeeklyReportEntity::getWeeklyNum, (Object)weeklyNum);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        queryWrapper.orderByDesc(WeeklyReportEntity::getWeeklyNum);
        queryWrapper.last("limit 1");
        WeeklyReportEntity entity = (WeeklyReportEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (null != entity) {
            reportVO.setLastWeeklyProgress(entity.getWeeklyProgress());
            reportVO.setPreFinishDate(entity.getPreFinishDate());
            reportVO.setStartDate(entity.getStartDate());
            reportVO.setYearPlanMny(entity.getYearPlanMny());
        } else {
            reportVO.setLastWeeklyProgress(BigDecimal.ZERO);
        }
        if (null != weeklyNum) {
            LocalDate today = LocalDate.now();
            int year = today.getYear();
            LocalDate startOfWeek = WeeklyReportServiceImpl.getStartOfWeek(year, weeklyNum);
            LocalDate endOfWeek = WeeklyReportServiceImpl.getEndOfWeek(startOfWeek);
            CommonResponse response2 = this.attendanceApi.queryNumByProjAndQj(startOfWeek.toString(), endOfWeek.toString(), projectId);
            if (response2.isSuccess() && null != response2.getData() && !Integer.valueOf(0).equals(response2.getData())) {
                int total = (Integer)response2.getData();
                int dayOfWeekNumber = today.getDayOfWeek().getValue();
                reportVO.setConstructionPersonNum(BigDecimal.valueOf((total + dayOfWeekNumber - 1) / dayOfWeekNumber));
            } else {
                reportVO.setConstructionPersonNum(BigDecimal.ZERO);
            }
        }
        if ((response = this.projectApi.queryProjectDetail(projectId)).isSuccess() && null != response.getData()) {
            ProjectRegisterVO registerVO = (ProjectRegisterVO)response.getData();
            CommonResponse membersResp = this.userApi.getEmployeeList(registerVO.getProjectDepartmentId());
            reportVO.setManagePersonNum(membersResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)membersResp.getData())) ? BigDecimal.valueOf(((List)membersResp.getData()).size()) : BigDecimal.ZERO);
        }
        if ((contResponse = this.incomeContractApi.searchContract(projectId)).isSuccess() && null != contResponse.getData()) {
            reportVO.setFinishDate(((ContractVo)contResponse.getData()).getEndDate());
            reportVO.setCostTotalMny(((ContractVo)contResponse.getData()).getContractTaxMny());
            reportVO.setContractTempMny(((ContractVo)contResponse.getData()).getContractTempMny());
        }
        BudgetProjectProParamControlVO controlVO = new BudgetProjectProParamControlVO();
        controlVO.setProjectId(projectId);
        controlVO.setCostType(Integer.valueOf(-1));
        CommonResponse commonResponse = this.budgetProjectProApi.fetchQuantityAndMny(controlVO);
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            reportVO.setPreCostMny(ComputeUtil.safeDiv((BigDecimal)((BudgetProjectProQuantityAndMnyVO)commonResponse.getData()).getBudgetTaxMny(), (BigDecimal)BigDecimal.valueOf(10000L)));
        } else {
            reportVO.setPreCostMny(BigDecimal.ZERO);
        }
        return reportVO;
    }

    @Override
    public IPage<WeeklyReportVO> queryReportList(QueryParam param) {
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("projectDirector", "desc");
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            params.put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            params.put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (params.containsKey("yyear") && ((Parameter)params.get("yyear")).getValue() != null) {
            param.getParams().put("sql", new Parameter("sql", (Object)(" YEAR(report_month) = " + ((Parameter)params.get("yyear")).getValue().toString())));
            params.remove("yyear");
        }
        IPage page = this.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List reportVOS = BeanMapper.mapList((Iterable)page.getRecords(), WeeklyReportVO.class);
        if (CollectionUtils.isNotEmpty((Collection)reportVOS)) {
            Map<Long, List<WeeklyReportVO>> map = reportVOS.stream().collect(Collectors.groupingBy(WeeklyReportVO::getProjectDirector));
            HashSet<Long> matchSet = new HashSet<Long>();
            for (WeeklyReportVO reportVO : reportVOS) {
                if (!matchSet.contains(reportVO.getProjectDirector())) {
                    List<WeeklyReportVO> list = map.get(reportVO.getProjectDirector());
                    reportVO.setRowSpan(Integer.valueOf(list.size()));
                    BigDecimal areaOutputMny = BigDecimal.ZERO;
                    BigDecimal areaPersonEfficiency = BigDecimal.ZERO;
                    for (WeeklyReportVO weeklyVO : list) {
                        areaOutputMny = ComputeUtil.safeAdd((BigDecimal)areaOutputMny, (BigDecimal)weeklyVO.getFinishOutputMny());
                        areaPersonEfficiency = ComputeUtil.safeAdd((BigDecimal)areaPersonEfficiency, (BigDecimal)weeklyVO.getManagePersonNum());
                    }
                    reportVO.setAreaOutputMny(areaOutputMny);
                    reportVO.setAreaPersonEfficiency(ComputeUtil.safeDiv((BigDecimal)areaOutputMny, (BigDecimal)areaPersonEfficiency));
                    matchSet.add(reportVO.getProjectDirector());
                } else {
                    reportVO.setRowSpan(Integer.valueOf(0));
                }
                reportVO.setNormalRowSpan(Integer.valueOf(1));
            }
        }
        pageData.setRecords(reportVOS);
        return pageData;
    }

    @Override
    public IPage<WeeklyReportVO> queryProblemList(QueryParam param) {
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("projectDirector", "desc");
        param.getOrderMap().put("weeklyNum", "asc");
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            params.put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            params.put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (params.containsKey("yyear") && ((Parameter)params.get("yyear")).getValue() != null) {
            param.getParams().put("sql", new Parameter("sql", (Object)(" YEAR(report_month) = " + ((Parameter)params.get("yyear")).getValue().toString())));
            params.remove("yyear");
        }
        QueryWrapper wrapper = WeeklyReportServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<WeeklyReportVO> reportVOS = ((WeeklyReportMapper)this.baseMapper).queryPageJson((Page<WeeklyReportVO>)page, (QueryWrapper<Object>)wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(reportVOS)) {
            Map<Long, List<WeeklyReportVO>> map = reportVOS.stream().collect(Collectors.groupingBy(WeeklyReportVO::getProjectDirector));
            HashSet<Long> matchSet = new HashSet<Long>();
            for (WeeklyReportVO reportVO : reportVOS) {
                if (!matchSet.contains(reportVO.getProjectDirector())) {
                    List<WeeklyReportVO> list = map.get(reportVO.getProjectDirector());
                    reportVO.setRowSpan(Integer.valueOf(list.size()));
                    matchSet.add(reportVO.getProjectDirector());
                } else {
                    reportVO.setRowSpan(Integer.valueOf(0));
                }
                reportVO.setNormalRowSpan(Integer.valueOf(1));
            }
        }
        pageData.setRecords(reportVOS);
        return pageData;
    }

    public static LocalDate getStartOfWeek(int year, int weekNumber) {
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        return firstDayOfYear.with(weekFields.weekOfYear(), weekNumber).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
    }

    public static LocalDate getEndOfWeek(LocalDate startOfWeek) {
        return startOfWeek.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
    }
}

