package com.ejianc.business.oa.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.oa.controller.query.WeeklyReportQuery;
import com.ejianc.business.oa.vo.ProjectDurationVO;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 周报
 *
 * @author generator
 *
 */
public interface IWeeklyReportService extends IBaseService<WeeklyReportEntity> {

    WeeklyReportVO saveOrUpdate(WeeklyReportVO weeklyReportVO);

    WeeklyReportVO afterProject(Long id, Long projectId, Integer weeklyNum);

    IPage<WeeklyReportVO> queryReportList(WeeklyReportQuery query);

    IPage<WeeklyReportVO> queryProblemList(QueryParam param);

    Map<Long, ProjectDurationVO> selectStartWorkReportTimeAndTermByProjectId(List<Long>  projectId);

    Integer queryWeeklyNum(WeeklyReportQuery query);
}
