package com.ejianc.business.oa.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;  // MyBatis-Plus 分页结果接口
import com.ejianc.business.oa.query.WeeklyReportRelatedQuery;  // 查询参数对象（DTO）
import com.ejianc.business.oa.vo.WeeklyReportRelatedVO;  // 视图对象（VO）
// 原来如此，后面代码里面的注解都是在上面用import引用的，
import org.apache.ibatis.annotations.Mapper;  // 标识MyBatis的Mapper接口
import org.apache.ibatis.annotations.Param;  // SQL参数绑定注解

import java.util.List;  // 列表接口

/**
 * 这个接口是和施工周报相关的接口
 * 作用是：调取开工报告、年度指标计划、收款登记、施工合同、施工周报相关里面的数据
 * 调取的数据如下
 * 1.开工报告：开工日期（开工报告）、开工日期（实际开工）、竣工日期（按开工报告）、竣工日期（按实际开工）、是否办理开工报告
 * 2.年度指标计划：年度指标计划
 * 3.收款登记：累计收款
 * 4.施工合同：合同总金额
 * 5.施工周报：选择项目的最新周报日期
*/
@Mapper
public interface WeeklyReportRelatedMapper {

    List<WeeklyReportRelatedVO> queryWeeklyReportRelatedList(@Param("page") IPage<WeeklyReportRelatedVO> page, @Param("query")WeeklyReportRelatedQuery query);

}