package com.ejianc.business.oa.vo;

import com.ejianc.business.project.vo.ReturnPlanDetailVO;
import com.ejianc.business.project.vo.ReturnRecordPlanVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目回款计划
 * 
 * @author generator
 * 
 */
public class HkReturnPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer seq;

    private String billCode; // 总计划单号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private String memo; // 备注
    private Integer changeState; // 变更状态 0:未变更 1：已变更  2：变更中
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更id
    
    private List<ReturnPlanDetailVO> detailList = new ArrayList<>(); // 项目回款计划-详情
    private List<ReturnRecordPlanVO> recordList = new ArrayList<>(); // 项目回款记录
    private String changeStateStr;
    private String billStateStr;


    private Long orgId; // 组织
    private String orgName; // 组织名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;//生效时间



    private Long scheduleUserId;//进度负责人
    private String scheduleUserName;//进度负责人
    private Long returnUserId;//回款负责人
    private String returnUserName;//回款负责人

    private String sendUserId;//抄送人
    private String sendUserName;//抄送人

    private String projectCode; // 项目编码

    private Long projectManager; //项目经理

    private String projectManagerName; //项目经理名称

    private String januaryProjectSchedule;//1月项目进度

    private String februaryProjectSchedule;//2月项目进度

    private String marchProjectSchedule;//3月项目进度

    private String aprilProjectSchedule;//4月项目进度

    private String mayProjectSchedule;//5月项目进度

    private String juneProjectSchedule;//6月项目进度

    private String julyProjectSchedule;//7月项目进度

    private String augustProjectSchedule;//8月项目进度

    private String septemberProjectSchedule;//9月项目进度

    private String octoberProjectSchedule;//10月项目进度

    private String novemberProjectSchedule;//11月项目进度

    private String decemberProjectSchedule;//12月项目进度


    // 2025-02-27日单据新增字段
    //private String projectCode; //项目编号
    private Long projectDirector; // 项目总监id
    private String projectDirectorName; // 项目总监name
    private BigDecimal initialProgress; // 年初进度百分比（手填）A
    private BigDecimal endProgress; // 年末计划百分比（年度计划指标最后月份的项目进度比）B
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractTempMny; // 合同暂列金
    private BigDecimal planOutput; // 年度计划产值
    private BigDecimal returnMoneySum; // 年度计划回款（年度计划指标--计划回款金颓 (万)合计）
    private BigDecimal planMgmtMnySum; // 年度计划管理费(ZD费)（年度计划指标--计划管理费(ZD费(万)合计）
    private BigDecimal planHeadcountSum; // 年度计划人次（年度计划指标--计划人次合计）

    // 2025-04-24 新增字段
    private Long deputyBossId; // 分管领导id
    private String deputyBossName; // 分管领导name
    private Long contractType; // 合同类型
    private String contractTypeName; //合同类型名称
    private Integer term;//合同工期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planEndDate; //计划完工日期

    public String getJanuaryProjectSchedule() {
        return januaryProjectSchedule;
    }

    public void setJanuaryProjectSchedule(String januaryProjectSchedule) {
        this.januaryProjectSchedule = januaryProjectSchedule;
    }

    public String getFebruaryProjectSchedule() {
        return februaryProjectSchedule;
    }

    public void setFebruaryProjectSchedule(String februaryProjectSchedule) {
        this.februaryProjectSchedule = februaryProjectSchedule;
    }

    public String getMarchProjectSchedule() {
        return marchProjectSchedule;
    }

    public void setMarchProjectSchedule(String marchProjectSchedule) {
        this.marchProjectSchedule = marchProjectSchedule;
    }

    public String getAprilProjectSchedule() {
        return aprilProjectSchedule;
    }

    public void setAprilProjectSchedule(String aprilProjectSchedule) {
        this.aprilProjectSchedule = aprilProjectSchedule;
    }

    public String getMayProjectSchedule() {
        return mayProjectSchedule;
    }

    public void setMayProjectSchedule(String mayProjectSchedule) {
        this.mayProjectSchedule = mayProjectSchedule;
    }

    public String getJuneProjectSchedule() {
        return juneProjectSchedule;
    }

    public void setJuneProjectSchedule(String juneProjectSchedule) {
        this.juneProjectSchedule = juneProjectSchedule;
    }

    public String getJulyProjectSchedule() {
        return julyProjectSchedule;
    }

    public void setJulyProjectSchedule(String julyProjectSchedule) {
        this.julyProjectSchedule = julyProjectSchedule;
    }

    public String getAugustProjectSchedule() {
        return augustProjectSchedule;
    }

    public void setAugustProjectSchedule(String augustProjectSchedule) {
        this.augustProjectSchedule = augustProjectSchedule;
    }

    public String getSeptemberProjectSchedule() {
        return septemberProjectSchedule;
    }

    public void setSeptemberProjectSchedule(String septemberProjectSchedule) {
        this.septemberProjectSchedule = septemberProjectSchedule;
    }

    public String getOctoberProjectSchedule() {
        return octoberProjectSchedule;
    }

    public void setOctoberProjectSchedule(String octoberProjectSchedule) {
        this.octoberProjectSchedule = octoberProjectSchedule;
    }

    public String getNovemberProjectSchedule() {
        return novemberProjectSchedule;
    }

    public void setNovemberProjectSchedule(String novemberProjectSchedule) {
        this.novemberProjectSchedule = novemberProjectSchedule;
    }

    public String getDecemberProjectSchedule() {
        return decemberProjectSchedule;
    }

    public void setDecemberProjectSchedule(String decemberProjectSchedule) {
        this.decemberProjectSchedule = decemberProjectSchedule;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }



    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getScheduleUserId() {
        return scheduleUserId;
    }
    @ReferDeserialTransfer
    public void setScheduleUserId(Long scheduleUserId) {
        this.scheduleUserId = scheduleUserId;
    }

    public String getScheduleUserName() {
        return scheduleUserName;
    }

    public void setScheduleUserName(String scheduleUserName) {
        this.scheduleUserName = scheduleUserName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getReturnUserId() {
        return returnUserId;
    }
    @ReferDeserialTransfer
    public void setReturnUserId(Long returnUserId) {
        this.returnUserId = returnUserId;
    }

    public String getReturnUserName() {
        return returnUserName;
    }

    public void setReturnUserName(String returnUserName) {
        this.returnUserName = returnUserName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public String getSendUserId() {
        return sendUserId;
    }
    @ReferDeserialTransfer
    public void setSendUserId(String sendUserId) {
        this.sendUserId = sendUserId;
    }

    public String getSendUserName() {
        return sendUserName;
    }

    public void setSendUserName(String sendUserName) {
        this.sendUserName = sendUserName;
    }

    public String getChangeStateStr() {
        return changeStateStr;
    }

    public void setChangeStateStr(String changeStateStr) {
        this.changeStateStr = changeStateStr;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public List<ReturnRecordPlanVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ReturnRecordPlanVO> recordList) {
        this.recordList = recordList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    
     public List<ReturnPlanDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<ReturnPlanDetailVO> detailList) {
        this.detailList = detailList;
     }

//    public String getProjectCode() {
//        return projectCode;
//    }
//
//    public void setProjectCode(String projectCode) {
//        this.projectCode = projectCode;
//    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectDirector() {
        return projectDirector;
    }

    @ReferDeserialTransfer
    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }

    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }

    public BigDecimal getInitialProgress() {
        return initialProgress;
    }

    public void setInitialProgress(BigDecimal initialProgress) {
        this.initialProgress = initialProgress;
    }

    public BigDecimal getEndProgress() {
        return endProgress;
    }

    public void setEndProgress(BigDecimal endProgress) {
        this.endProgress = endProgress;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractTempMny() {
        return contractTempMny;
    }

    public void setContractTempMny(BigDecimal contractTempMny) {
        this.contractTempMny = contractTempMny;
    }

    public BigDecimal getPlanOutput() {
        return planOutput;
    }

    public void setPlanOutput(BigDecimal planOutput) {
        this.planOutput = planOutput;
    }

    public BigDecimal getReturnMoneySum() {
        return returnMoneySum;
    }

    public void setReturnMoneySum(BigDecimal returnMoneySum) {
        this.returnMoneySum = returnMoneySum;
    }

    public BigDecimal getPlanMgmtMnySum() {
        return planMgmtMnySum;
    }

    public void setPlanMgmtMnySum(BigDecimal planMgmtMnySum) {
        this.planMgmtMnySum = planMgmtMnySum;
    }

    public BigDecimal getPlanHeadcountSum() {
        return planHeadcountSum;
    }

    public void setPlanHeadcountSum(BigDecimal planHeadcountSum) {
        this.planHeadcountSum = planHeadcountSum;
    }

    public Long getDeputyBossId() {
        return deputyBossId;
    }

    public void setDeputyBossId(Long deputyBossId) {
        this.deputyBossId = deputyBossId;
    }

    public String getDeputyBossName() {
        return deputyBossName;
    }

    public void setDeputyBossName(String deputyBossName) {
        this.deputyBossName = deputyBossName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }
    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public Integer getTerm(){
        return term;
    }

    public void setTerm(Integer term){
        this.term = term;
    }

    public Date getPlanEndDate(){
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate){
        this.planEndDate = planEndDate;
    }

}
