package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周报
 *
 * @author generator
 *
 */
 @TableName("ejc_weekly_report")
public class WeeklyReportEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_manager")
    private Long projectManager; // 项目经理
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理名称
    @TableField(value="project_director")
    private Long projectDirector; // 项目总监
    @TableField(value="project_director_name")
    private String projectDirectorName; // 项目总监名称
    @TableField(value="weekly_num")
    private Integer weeklyNum; // 第几周
    @TableField(value="last_weekly_progress")
    private BigDecimal lastWeeklyProgress; // 上周进度
    @TableField(value="weekly_progress")
    private BigDecimal weeklyProgress; // 本周进度
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="pre_finish_date")
    private Date preFinishDate; // 预计实际完工时间
    @TableField(value="cost_total_mny")
    private BigDecimal costTotalMny; // 项目金额
    @TableField(value="pre_cost_mny")
    private BigDecimal preCostMny; // 预计总成本
    @TableField(value="finish_output_mny")
    private BigDecimal finishOutputMny; // 本周完成产值
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="report_date")
    private Date reportDate; // 上报时间
    @TableField(value="proj_person_efficiency")
    private BigDecimal projPersonEfficiency; // 项目人效
    @TableField(value="construction_person_num")
    private BigDecimal constructionPersonNum; // 施工人数
    @TableField(value="manage_person_num")
    private BigDecimal managePersonNum; // 管理人员
    @TableField(value="proj_progress")
    private String projProgress; // 项目进展
    @TableField(value="weekly_problem")
    private String weeklyProblem; // 本周问题
    @TableField(value="memo")
    private String memo; // 备注
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    @TableField(value="finish_date")
    private Date finishDate; // 实际完工时间

    @TableField(value="statistics_date")
    private Date statisticsDate; // 统计日期
    @TableField(value="start_date")
    private Date startDate; // 实际开工时间
    @TableField(value="report_month")
    private Date reportMonth; // 统计月份
    @TableField(value="year_plan_mny")
    private BigDecimal yearPlanMny; // 年度计划产值
    @TableField(value="contract_temp_mny")
    private BigDecimal contractTempMny; // 合同暂列金
    @TableField(value="sum_finish_mny")
    private BigDecimal sumFinishMny; // 累计完成产值

    @TableField(exist=false)
    @SubEntity(serviceName="weeklyReportManagerService")
    private List<WeeklyReportManagerEntity> managerList = new ArrayList<>(); // 周报-管理人员

    @TableField(exist=false)
    @SubEntity(serviceName="weeklyReportDetailService")
    private List<WeeklyReportDetailEntity> weeklyReportDetailList = new ArrayList<>(); // 周报-本周问题

    // 2025-05-28 新增子表
    @TableField(exist=false)
    @SubEntity(serviceName="weeklyReportProjectService")
    private List<WeeklyReportProjectEntity> weeklyReportProjectList = new ArrayList<>(); // 周报-项目管理人员及责任分工

    // 2025-04-25 新增字段
    @TableField(value="term")
    private Integer term; // 合同工期
    @TableField(value="plan_term")
    private Integer planTerm; // 计划工期
    @TableField(value="report")
    private Integer report; // 是否办理开工报告
    @TableField(value="week_payment")
    private BigDecimal weekPayment; // 本周回款
    @TableField(value="week_payment_sum")
    private BigDecimal weekPaymentSum; // 累计回款
    @TableField(value="week_payment_ratio")
    private BigDecimal weekPaymentRatio; // 累计回款比例

    // 2025-06-24 新增字段
    @TableField(value="efficiency_coefficient_sum")
    private BigDecimal efficiencyCoefficientSum; // 项目人效系数

    // 2025-09-16 新增字段
    @TableField(value = "engineering_type")
    private Long engineeringType;  // 工程类型
    @TableField(value = "engineering_type_name")
    private String engineeringTypeName;  //工程类型名称

    public BigDecimal getContractTempMny() {
        return contractTempMny;
    }

    public void setContractTempMny(BigDecimal contractTempMny) {
        this.contractTempMny = contractTempMny;
    }

    public BigDecimal getSumFinishMny() {
        return sumFinishMny;
    }

    public void setSumFinishMny(BigDecimal sumFinishMny) {
        this.sumFinishMny = sumFinishMny;
    }

    public List<WeeklyReportDetailEntity> getWeeklyReportDetailList() {
        return weeklyReportDetailList;
    }

    public void setWeeklyReportDetailList(List<WeeklyReportDetailEntity> weeklyReportDetailList) {
        this.weeklyReportDetailList = weeklyReportDetailList;
    }

    public List<WeeklyReportProjectEntity> getWeeklyReportProjectList() {
        return weeklyReportProjectList;
    }

    public void setWeeklyReportProjectList(List<WeeklyReportProjectEntity> weeklyReportProjectList) {
        this.weeklyReportProjectList = weeklyReportProjectList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public Long getProjectDirector() {
        return projectDirector;
    }

    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }
    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }
    public Integer getWeeklyNum() {
        return weeklyNum;
    }

    public void setWeeklyNum(Integer weeklyNum) {
        this.weeklyNum = weeklyNum;
    }
    public BigDecimal getLastWeeklyProgress() {
        return lastWeeklyProgress;
    }

    public void setLastWeeklyProgress(BigDecimal lastWeeklyProgress) {
        this.lastWeeklyProgress = lastWeeklyProgress;
    }
    public BigDecimal getWeeklyProgress() {
        return weeklyProgress;
    }

    public void setWeeklyProgress(BigDecimal weeklyProgress) {
        this.weeklyProgress = weeklyProgress;
    }
    public Date getPreFinishDate() {
        return preFinishDate;
    }

    public void setPreFinishDate(Date preFinishDate) {
        this.preFinishDate = preFinishDate;
    }
    public BigDecimal getCostTotalMny() {
        return costTotalMny;
    }

    public void setCostTotalMny(BigDecimal costTotalMny) {
        this.costTotalMny = costTotalMny;
    }
    public BigDecimal getPreCostMny() {
        return preCostMny;
    }

    public void setPreCostMny(BigDecimal preCostMny) {
        this.preCostMny = preCostMny;
    }
    public BigDecimal getFinishOutputMny() {
        return finishOutputMny;
    }

    public void setFinishOutputMny(BigDecimal finishOutputMny) {
        this.finishOutputMny = finishOutputMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getProjPersonEfficiency() {
        return projPersonEfficiency;
    }

    public void setProjPersonEfficiency(BigDecimal projPersonEfficiency) {
        this.projPersonEfficiency = projPersonEfficiency;
    }
    public BigDecimal getConstructionPersonNum() {
        return constructionPersonNum;
    }

    public void setConstructionPersonNum(BigDecimal constructionPersonNum) {
        this.constructionPersonNum = constructionPersonNum;
    }
    public BigDecimal getManagePersonNum() {
        return managePersonNum;
    }

    public void setManagePersonNum(BigDecimal managePersonNum) {
        this.managePersonNum = managePersonNum;
    }
    public String getProjProgress() {
        return projProgress;
    }

    public void setProjProgress(String projProgress) {
        this.projProgress = projProgress;
    }
    public String getWeeklyProblem() {
        return weeklyProblem;
    }

    public void setWeeklyProblem(String weeklyProblem) {
        this.weeklyProblem = weeklyProblem;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getStatisticsDate() {
        return statisticsDate;
    }

    public void setStatisticsDate(Date statisticsDate) {
        this.statisticsDate = statisticsDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(Date reportMonth) {
        this.reportMonth = reportMonth;
    }

    public BigDecimal getYearPlanMny() {
        return yearPlanMny;
    }

    public void setYearPlanMny(BigDecimal yearPlanMny) {
        this.yearPlanMny = yearPlanMny;
    }

    public List<WeeklyReportManagerEntity> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<WeeklyReportManagerEntity> managerList) {
        this.managerList = managerList;
    }

    public Integer getTerm() {
        return term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getPlanTerm() {
        return planTerm;
    }

    public void setPlanTerm(Integer planTerm) {
        this.planTerm = planTerm;
    }

    public Integer getReport() {
        return report;
    }

    public void setReport(Integer report) {
        this.report = report;
    }

    public BigDecimal getWeekPayment() {
        return weekPayment;
    }

    public void setWeekPayment(BigDecimal weekPayment) {
        this.weekPayment = weekPayment;
    }

    public BigDecimal getWeekPaymentSum() {
        return weekPaymentSum;
    }

    public void setWeekPaymentSum(BigDecimal weekPaymentSum) {
        this.weekPaymentSum = weekPaymentSum;
    }

    public BigDecimal getWeekPaymentRatio() {
        return weekPaymentRatio;
    }

    public void setWeekPaymentRatio(BigDecimal weekPaymentRatio) {
        this.weekPaymentRatio = weekPaymentRatio;
    }

    public BigDecimal getEfficiencyCoefficientSum() {
        return efficiencyCoefficientSum;
    }

    public void setEfficiencyCoefficientSum(BigDecimal efficiencyCoefficientSum) {
        this.efficiencyCoefficientSum = efficiencyCoefficientSum;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

}
