package com.ejianc.business.oa.service.impl;


// 1. 框架与工具库​
// MyBatis-Plus​​（ORM框架）：
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
// Spring Framework​​（核心框架）：
import com.ejianc.business.oa.vo.WeeklyProjectRelatedVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
//​Checker Framework​​（静态分析工具）：

// 2. 项目内部模块​
// 业务模块（com.ejianc.business.hk）：
//import com.ejianc.business.hk.enums.ArchivesEnum;  // 枚举定义
import com.ejianc.business.oa.mapper.WeeklyProjectRelatedMapper;  // Mapper接口（数据访问层）
import com.ejianc.business.oa.query.WeeklyProjectRelatedQuery;  // 查询参数对象（DTO）
import com.ejianc.business.oa.service.IWeeklyProjectRelatedService;  // 服务接口（业务层）
//import com.ejianc.business.hk.vo.HKDefdocDetailVO;  // 其他业务VO
// 组织中心模块（com.ejianc.foundation.orgcenter）：
import com.ejianc.foundation.orgcenter.api.IOrgApi;  // 组织中心API
import com.ejianc.foundation.orgcenter.vo.OrgVO;  // 组织中心VO
// 支持模块（com.ejianc.foundation.support）：
import com.ejianc.foundation.support.api.IDefdocApi;  // 文档服务API
//​基础框架（com.ejianc.framework.core）：
import com.ejianc.framework.core.context.InvocationInfoProxy;  // 上下文代理

// 3.Java 标准库​
// 集合与工具类：
import java.util.ArrayList;  // 动态数组
import java.util.List;  // 列表接口
// 函数式编程：
import java.util.stream.Collectors;  // Stream操作工具


/**
 * 这个ServiceImpl是和施工周报相关的接口的ServiceImpl
 * 作用是：获取该项目在“项目责任分工”下子表的数据
 * 存储的数据如下
 * 项目责任分工：子表数据的id、姓名、工号、职级、项目职务、2.0责任分工、是否区域主管
 */
@Service("WeeklyProjectRelatedServiceImpl")
public class WeeklyProjectRelatedServiceImpl implements IWeeklyProjectRelatedService {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;


    @Autowired
    private WeeklyProjectRelatedMapper weeklyProjectRelatedMapper;

    @Override
    public IPage<WeeklyProjectRelatedVO> queryWeeklyProjectRelatedList(WeeklyProjectRelatedQuery query) {

        /** 租户隔离 */
        // query.xxx,是query里面的代码
        // InvocationInfoProxy这个是依赖里面的东西，跟着写就行了
        query.setTenantId(InvocationInfoProxy.getTenantid());

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        query.setOrgIdList(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        IPage<WeeklyProjectRelatedVO> page = new Page<>(query.getPageNum(), query.getPageSize());
        List<WeeklyProjectRelatedVO> result = new ArrayList<>();
        if (query.getDisAblePage()){
            result = weeklyProjectRelatedMapper.queryWeeklyProjectRelatedList(null, query);
        }else{
            result = weeklyProjectRelatedMapper.queryWeeklyProjectRelatedList(page, query);
        }

        // 重新赋值id
        if(result != null && result.size() > 0){
            result.forEach(item -> {
                item.setId(IdWorker.getId());
            });
        }

        // 设置分页
        page.setRecords(result);

        return page;

    }

}