package com.ejianc.business.oa.query;

import java.util.ArrayList;
import java.util.List;


/**
 * 这个Query是和施工周报相关的接口的Query
 * 作用是：获取该项目在“项目责任分工”下子表的数据
 * Query里面的值：1.数据隔离，2.分页参数、3.给sql语句传递的值projectCode--项目编码
 * 存储的数据如下
 * 项目责任分工：子表数据的id、姓名、工号、职级、项目职务、2.0责任分工、是否区域主管
 */
public class WeeklyProjectRelatedQuery {
    // 数据隔离
    private Long tenantId;
    private List<Long> orgIdList = new ArrayList<>();

    //分页
    private Integer pageNum = 1; // 起始页
    private Integer pageSize = 10000; // 每页大小
    private Boolean disAblePage = true; // 是否禁用分页

    // 做筛选用
    private String projectCode; // 项目编码

    //-------------分割线------------------------------------
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public List<Long> getOrgIdList() {
        return orgIdList;
    }

    public void setOrgIdList(List<Long> orgIdList) {
        this.orgIdList = orgIdList;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getDisAblePage() {
        return disAblePage;
    }

    public void setDisAblePage(Boolean disAblePage) {
        this.disAblePage = disAblePage;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
}