package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.MonthBudgetFormDetailEntity;
import com.ejianc.business.oa.mapper.MonthBudgetFormDetailMapper;
import com.ejianc.business.oa.service.IMonthBudgetFormDetailService;
import com.ejianc.business.oa.service.IMonthBudgetFormService;
import com.ejianc.business.oa.vo.MonthBudgetReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 月度收支填报-子实体
 *
 * @author generator
 *
 */
@Service("monthBudgetFormDetailService")
public class MonthBudgetFormDetailServiceImpl extends BaseServiceImpl<MonthBudgetFormDetailMapper, MonthBudgetFormDetailEntity> implements IMonthBudgetFormDetailService{


    @Override
    public JSONObject queryMonthReport(QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<MonthBudgetReportVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper<MonthBudgetReportVO> wrapper = changeToQueryWrapper(param);
        List<MonthBudgetReportVO> allDataList = baseMapper.queryMonthReport(wrapper);
        jsonObject.put("records", allDataList);
        jsonObject.put("total", pages.getTotal());
        jsonObject.put("current", pages.getCurrent());
        jsonObject.put("size", pages.getSize());
        jsonObject.put("pages", pages.getPages());
        return jsonObject;
    }

    @Override
    public List<MonthBudgetReportVO> exportMonthReport(QueryParam queryParam) {
        queryParam.setPageIndex(1);
        queryParam.setPageSize(-1);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<MonthBudgetReportVO> pages = new Page<>((long) queryParam.getPageIndex(), (long) queryParam.getPageSize());
        QueryWrapper<MonthBudgetReportVO> wrapper = changeToQueryWrapper(queryParam);
        List<MonthBudgetReportVO> allDataList = baseMapper.queryMonthReport(wrapper);
        return allDataList;
    }
}
