package com.ejianc.business.procBid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procBid.bean.SupplierApprovalDetailEntity;
/**
 * 投标单位入围名单审批表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proc_supplier_approval")
public class SupplierApprovalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_date")
    private Date billDate; // 填写日期
    @TableField(value="bill_code")
    private String billCode; // 编码规则
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="org_id")
    private Long orgId; // 组织ID
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="purchase_id")
    private Long purchaseId; // 采购事项ID
    @TableField(value="purchase_code")
    private String purchaseCode; // 采购事项编码
    @TableField(value="purchase_name")
    private String purchaseName; // 采购事项名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="proc_type")
    private String procType; // 招采类型
    @TableField(value="proc_category")
    private String procCategory; // 招采品类
    @TableField(value="profession")
    private String profession; // 专业
    @TableField(value="estimated_mny")
    private BigDecimal estimatedMny; // 预估标的物金额
    @TableField(value="proc_method")
    private String procMethod; // 招标方式(拟采购方式)
    @TableField(value="opt_attachment")
    private String optAttachment; // 选择性附件
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="supplierApprovalDetailService")
    private List<SupplierApprovalDetailEntity> supplierApprovalDetailList = new ArrayList<>(); // 投标单位入围名单审批表-子表
    

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }
    public String getPurchaseCode() {
        return purchaseCode;
    }

    public void setPurchaseCode(String purchaseCode) {
        this.purchaseCode = purchaseCode;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProcType() {
        return procType;
    }

    public void setProcType(String procType) {
        this.procType = procType;
    }
    public String getProcCategory() {
        return procCategory;
    }

    public void setProcCategory(String procCategory) {
        this.procCategory = procCategory;
    }
    public String getProfession() {
        return profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }
    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }
    public String getProcMethod() {
        return procMethod;
    }

    public void setProcMethod(String procMethod) {
        this.procMethod = procMethod;
    }
    public String getOptAttachment() {
        return optAttachment;
    }

    public void setOptAttachment(String optAttachment) {
        this.optAttachment = optAttachment;
    }
    

    public List<SupplierApprovalDetailEntity> getSupplierApprovalDetailList() {
        return supplierApprovalDetailList;
    }

    public void setSupplierApprovalDetailList(List<SupplierApprovalDetailEntity> supplierApprovalDetailList) {
        this.supplierApprovalDetailList = supplierApprovalDetailList;
    }
}
