package com.ejianc.business.home.controller;

import com.ejianc.business.home.service.IHomePortalService;
import com.ejianc.business.home.vo.MonthProductVO;
import com.ejianc.business.home.vo.ProjectTermNumVO;
import com.ejianc.business.home.vo.RiskProjectVO;
import com.ejianc.business.home.vo.YearProductVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 门户首页 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2022-04-28
 */
@RestController
@RequestMapping("/homePortal")
public class HomePortalController {

    @Autowired
    private IHomePortalService service;

    // 本年月度产值
    @RequestMapping(value = "/monthProductMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, List<MonthProductVO>>> monthProductMny(@RequestParam(value = "status", required = false) String status) {
        Map<String, List<MonthProductVO>> result = service.monthProductMny(status);
        return CommonResponse.success(result);
    }

    // 工期风险管理
    @RequestMapping(value = "/projectTerm", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTermNumVO> projectTerm() {
        ProjectTermNumVO result = service.projectTerm();
        return CommonResponse.success(result);
    }

    // 年度产值
    @RequestMapping(value = "/yearProductMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<YearProductVO> yearProductMny() {
        YearProductVO result = service.yearProductMny();
        return CommonResponse.success(result);
    }

    // 项目风险管理
    @RequestMapping(value = "/riskProjectNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RiskProjectVO> riskProjectNum() {
        RiskProjectVO result = service.riskProjectNum();
        return CommonResponse.success(result);
    }
}

