package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.CALockRegisterDetailEntity;
/**
 * CA锁登记主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ca_lock_register")
public class CALockRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="ca_lock_name")
    private String caLockName; // CA锁名称
    @TableField(value="ca_lock_type")
    private String caLockType; // CA锁类型
    @TableField(value="head_id")
    private Long headId; // 负责人
    @TableField(value="head_name")
    private String headName; // 负责人名称
    @TableField(value="expiry_date")
    private Date expiryDate; // 有效期至
    @TableField(value="remind_date")
    private Date remindDate; // 提醒日期
    @TableField(value="start_flag")
    private Integer startFlag; // 是否启用 0-否、1-是
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="cALockRegisterDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<CALockRegisterDetailEntity> detailList = new ArrayList<>(); // CA锁登记-子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getCaLockName() {
        return caLockName;
    }

    public void setCaLockName(String caLockName) {
        this.caLockName = caLockName;
    }
    public String getCaLockType() {
        return caLockType;
    }

    public void setCaLockType(String caLockType) {
        this.caLockType = caLockType;
    }
    public Long getHeadId() {
        return headId;
    }

    public void setHeadId(Long headId) {
        this.headId = headId;
    }
    public String getHeadName() {
        return headName;
    }

    public void setHeadName(String headName) {
        this.headName = headName;
    }
    public Date getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }
    public Date getRemindDate() {
        return remindDate;
    }

    public void setRemindDate(Date remindDate) {
        this.remindDate = remindDate;
    }
    public Integer getStartFlag() {
        return startFlag;
    }

    public void setStartFlag(Integer startFlag) {
        this.startFlag = startFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public List<CALockRegisterDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CALockRegisterDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
