package com.ejianc.business.oa.query;

import java.util.ArrayList;
import java.util.List;

/**
 * 这个Query是和施工周报相关的接口的Query
 * 作用是：收款登记的下面项目的所有的收款相关，然后把数据交给前端来处理
 * Query里面的值：1.数据隔离，2.分页参数、3.给sql语句传递的值projectId--项目ID
 * 相关的数据如下
 * 收款登记：此项目的项目ID、该项目每个单据的办理时间、该项目每个单据的收款金额
 */
public class WeeklyReportCollectionQuery {
    // 数据隔离
    private Long tenantId;
    private List<Long> orgIdList = new ArrayList<>();

    //分页
    private Integer pageNum = 1; // 起始页
    private Integer pageSize = 10000; // 每页大小
    private Boolean disAblePage = true; // 是否禁用分页

    // 做筛选用
    private String projectId; // 项目ID

    //-------------分割线------------------------------------
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public List<Long> getOrgIdList() {
        return orgIdList;
    }

    public void setOrgIdList(List<Long> orgIdList) {
        this.orgIdList = orgIdList;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getDisAblePage() {
        return disAblePage;
    }

    public void setDisAblePage(Boolean disAblePage) {
        this.disAblePage = disAblePage;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
}