package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CertApplyDetailEntity;
import com.ejianc.business.oa.bean.CertApplyEntity;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.ICertApplyDetailService;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.CertApplyListVO;
import com.ejianc.business.oa.vo.CertApplyVO;
import com.ejianc.business.oa.vo.CertRecordListVO;
import com.ejianc.business.oa.vo.CertRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertRecordMapper;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.service.ICertRecordService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 证照使用记录
 * 
 * @author generator
 * 
 */
@Service("certRecordService")
public class CertRecordServiceImpl extends BaseServiceImpl<CertRecordMapper, CertRecordEntity> implements ICertRecordService{
    @Autowired
    private ICertRecordService service;
    @Autowired
    private ICertApplyDetailService certApplyDetailService;
    @Autowired
    private IManagementService managementService;
    @Autowired
    private ICertRecordService recordService;

    @Transactional
    @Override
    public void deleteById(CertRecordVO vo) {
        boolean removeById = service.removeById(vo.getId());
        if (!removeById){
            throw new BusinessException("网络异常，证照使用记录删除失败，请稍后再试");
        }
        //更新证照状态和库存地址
        //查询出删除之后最新一条证照使用记录
        //回写订单状态
        LambdaQueryWrapper<CertRecordEntity> wrapperCertRecord = Wrappers.<CertRecordEntity>lambdaQuery();
        wrapperCertRecord.eq(CertRecordEntity::getCertId, vo.getCertId());
        wrapperCertRecord.orderByDesc(CertRecordEntity::getCreateTime);

        List<CertRecordEntity> certRecordList = service.list(wrapperCertRecord);
        CertRecordEntity certRecordEntity = null;
        if (ListUtil.isNotEmpty(certRecordList)){
            certRecordEntity = certRecordList.get(0);
        }

        LambdaUpdateWrapper<ManagementEntity> updateManageWrapper = new LambdaUpdateWrapper<>();
        updateManageWrapper.eq(ManagementEntity::getId, vo.getCertId());
        //操作类型(1-借出,0-归还,2-借出已归还)
        if (certRecordEntity != null){
            updateManageWrapper.set(ManagementEntity::getStockStatus, (certRecordEntity.getOptType() == 1 || certRecordEntity.getOptType() == 2) ? 1:0 );
        }
        if (certRecordEntity == null){
            updateManageWrapper.set(ManagementEntity::getStockStatus, 0);
        }
        boolean updateCertSatausOrder = managementService.update(updateManageWrapper);
        if (!updateCertSatausOrder){
            throw new BusinessException("网络异常，证照状态更新失败，请稍后再试");
        }
    }

    @Override
    public void deleteByFk(List<Long> ids) {
        LambdaQueryWrapper<CertRecordEntity> wrapperCertRecord = Wrappers.<CertRecordEntity>lambdaQuery();
        wrapperCertRecord.eq(CertRecordEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapperCertRecord.in(CertRecordEntity::getCertId, ids);
        List<CertRecordEntity> certRecordList = service.list(wrapperCertRecord);
        List<Long> id = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(certRecordList)){
            id.addAll(certRecordList.stream().map(CertRecordEntity::getId).collect(Collectors.toList()));
            super.removeByIds(id);
        }
    }

    @Override
    public List<CertRecordListVO> getOutList(Page<CertRecordListVO> page, QueryWrapper wrapper) {
        List<CertRecordListVO> list = baseMapper.getOutList(page, wrapper);
        return list;
    }
    @Transactional
    @Override
    public CommonResponse<CertRecordVO> applySaveRecord(CertRecordVO saveorUpdateVO) {
        CertRecordEntity entity = BeanMapper.map(saveorUpdateVO, CertRecordEntity.class);
        service.saveOrUpdate(entity, false);
        CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);
        if (saveorUpdateVO.getOptType() == 1){
            //更新待处理状态
            LambdaUpdateWrapper<CertApplyDetailEntity> updateCertDetailWrapper = new LambdaUpdateWrapper<>();
            updateCertDetailWrapper.eq(CertApplyDetailEntity::getId, saveorUpdateVO.getApplyDetailId());
            updateCertDetailWrapper.set(CertApplyDetailEntity::getDealStatus, 2);
            boolean updateFlagOrder = certApplyDetailService.update(updateCertDetailWrapper);
            if (!updateFlagOrder){
                throw new BusinessException("网络异常，待处理状态更新失败，请稍后再试");
            }
        }
        //归还的话,更新最新一条借出状态为已归还
        if (saveorUpdateVO.getOptType() == 0){
            LambdaUpdateWrapper<CertRecordEntity> updateRecordWrapper = new LambdaUpdateWrapper<>();
            updateRecordWrapper.eq(CertRecordEntity::getId, saveorUpdateVO.getRecordId());
            updateRecordWrapper.set(CertRecordEntity::getOptType, 2);
            //归还的话,更新归还地址

            boolean updateCertRecordOrder = recordService.update(updateRecordWrapper);
            if (!updateCertRecordOrder){
                throw new BusinessException("网络异常，记录状态更新失败，请稍后再试");
            }
        }

        //更新证照状态
        LambdaUpdateWrapper<ManagementEntity> updateManageWrapper = new LambdaUpdateWrapper<>();
        updateManageWrapper.eq(ManagementEntity::getId, saveorUpdateVO.getCertId());
        updateManageWrapper.set(ManagementEntity::getStockStatus, saveorUpdateVO.getOptType());
        updateManageWrapper.set(ManagementEntity::getCertStatus, saveorUpdateVO.getCertStatus());

        //归还的话,更新归还地址
        if (saveorUpdateVO.getOptType() == 0){
            updateManageWrapper.set(ManagementEntity::getStorageLocation, saveorUpdateVO.getAddr());
        }
        boolean updateCertSatausOrder = managementService.update(updateManageWrapper);
        if (!updateCertSatausOrder){
            throw new BusinessException("网络异常，证照状态更新失败，请稍后再试");
        }
//
//        //查询最后一次借出归还记录
//        LambdaQueryWrapper<CertRecordEntity> wrapperCertRecord = Wrappers.<CertRecordEntity>lambdaQuery();
//        wrapperCertRecord.eq(CertRecordEntity::getTenantId, InvocationInfoProxy.getTenantid());
//        wrapperCertRecord.in(CertRecordEntity::getCertId, saveorUpdateVO.getCertId());
//        wrapperCertRecord.orderByDesc(CertRecordEntity::getCreateTime);
//        List<CertRecordEntity> certRecordList = service.list(wrapperCertRecord);
//        //取出时间(借出或者归还)
//        if (ListUtil.isNotEmpty(certRecordList)){
//            Date useTime = certRecordList.get(0).getUseTime();
//            if (useTime.getTime() > saveorUpdateVO.getUseTime().getTime()){
//                if (saveorUpdateVO.getOptType() == 0){
//                    throw new BusinessException("归还时间必须大于上次借出");
//                }
//                if (saveorUpdateVO.getOptType() == 1){
//
//                }
//
//
//            }
//
//
//        }
//        //校验借出/归还时间,借出时间大于上一次归还时间,或归还时间大于上一次借出时间
//        //校验归还时间大于上一次借出时间
//        if (saveorUpdateVO.getOptType() == 0){
//
//        }
//        //校验借出时间大于上一次归还时间
//        if (saveorUpdateVO.getOptType() == 1){
//
//        }


        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @Transactional
    @Override
    public CommonResponse<CertRecordVO> manageSaveRecord(CertRecordVO saveorUpdateVO) {
        CertRecordEntity entity = BeanMapper.map(saveorUpdateVO, CertRecordEntity.class);
        service.saveOrUpdate(entity, false);
        CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);

        //更新证照状态
        LambdaUpdateWrapper<ManagementEntity> updateManageWrapper = new LambdaUpdateWrapper<>();
        updateManageWrapper.eq(ManagementEntity::getId, saveorUpdateVO.getCertId());
        updateManageWrapper.set(ManagementEntity::getStockStatus, saveorUpdateVO.getOptType());
        updateManageWrapper.set(ManagementEntity::getCertStatus, saveorUpdateVO.getCertStatus());

        //归还的话,更新归还地址
        if (saveorUpdateVO.getOptType() == 0){
            updateManageWrapper.set(ManagementEntity::getStorageLocation, saveorUpdateVO.getAddr());
        }
        boolean updateCertSatausOrder = managementService.update(updateManageWrapper);
        if (!updateCertSatausOrder){
            throw new BusinessException("网络异常，证照状态更新失败，请稍后再试");
        }

        //归还的话,更新最新一条借出状态为已归还
        //查询出最新一条借出记录
        LambdaQueryWrapper<CertRecordEntity> queryRecordWrapper = new LambdaQueryWrapper<>();
        queryRecordWrapper.eq(CertRecordEntity::getCertId,saveorUpdateVO.getCertId());
        queryRecordWrapper.eq(CertRecordEntity::getOptType,1);
        List<CertRecordEntity> list = recordService.list(queryRecordWrapper);
        Long recordId = null;
        if (ListUtil.isNotEmpty(list)){
            recordId = list.get(0).getId();
            if (saveorUpdateVO.getOptType() == 0){
                LambdaUpdateWrapper<CertRecordEntity> updateRecordWrapper = new LambdaUpdateWrapper<>();
                updateRecordWrapper.eq(CertRecordEntity::getId, recordId);
                updateRecordWrapper.set(CertRecordEntity::getOptType, 2);
                boolean updateCertRecordOrder = recordService.update(updateRecordWrapper);
                if (!updateCertRecordOrder){
                    throw new BusinessException("网络异常，记录状态更新失败，请稍后再试");
                }
            }
        }


        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @Transactional
    @Override
    public CommonResponse<CertRecordVO> manageUpdateRecord(CertRecordVO saveorUpdateVO) {

        CertRecordEntity entity = BeanMapper.map(saveorUpdateVO, CertRecordEntity.class);
        service.saveOrUpdate(entity, false);
        CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);
        if (saveorUpdateVO.getOptType() == 0){
            //更新证照地址
            LambdaUpdateWrapper<ManagementEntity> updateManageWrapper = new LambdaUpdateWrapper<>();
            updateManageWrapper.eq(ManagementEntity::getId, saveorUpdateVO.getCertId());
            //归还的话,更新归还地址
            updateManageWrapper.set(ManagementEntity::getStorageLocation, saveorUpdateVO.getAddr());
            boolean updateCertSatausOrder = managementService.update(updateManageWrapper);
            if (!updateCertSatausOrder){
                throw new BusinessException("网络异常，证照状态更新失败，请稍后再试");
            }
        }


        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
