package com.ejianc.business.oa.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.controller.query.WeeklyReportQuery;
import com.ejianc.business.oa.vo.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 周报
 * 
 * @author generator
 * 
 */
@Mapper
public interface WeeklyReportMapper extends BaseCrudMapper<WeeklyReportEntity> {

    List<WeeklyReportVO> queryPageJson(Page<WeeklyReportVO> page, @Param(Constants.WRAPPER) QueryWrapper<Object> wrapper);

    Map<String, Object> selectStartWorkReportTimeAndTermByProjectId(@Param("projectId") Long projectId);

    @MapKey(value = "projectId")
    Map<Long,ProjectDurationVO> queryProjectDurationMap(@Param("projectIdList") List<Long> projectIdList);

    // 查询周报列表2.0
    List<WeeklyReportEntity> queryReportList(@Param("page")IPage<WeeklyReportEntity> page,@Param("query") WeeklyReportQuery query);

    // 查询实际轴数
    Integer queryWeeklyNum(@Param("query") WeeklyReportQuery query);

    BigDecimal queryPlanOutputByProjectCode(@Param("projectId") Long projectId);

    MarketStartWorkReportVO queryStartWorkReportByProjectId(@Param("projectId")Long projectId);

    HkReturnPlanVO queryReturnPlanByProjectId(@Param("projectId")Long projectId);

    FinanceReceiveVO queryReceiveByProjectId(@Param("projectId")Long projectId);

    List<WeeklyProjectManagerVO> queryProjectManagerByProjectId(@Param("projectId") Long projectId);
}
