package com.ejianc.business.oa.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 招标文件评审实体
 *
 * @author generator
 *
 */
 @TableName("oa_invite")
public class InviteEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private  String billCode; // 单据编号
    @TableField(value="opportunity_name")
    private  String opportunityName; // 工程名称
    @TableField(value="bond_mny")
    private BigDecimal bondMny; // 招标保证金
    @TableField(value="invite_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inviteDate; // 招标时间
    @TableField(value="bill_state")
    private  Integer billState; // 单据状态
    @TableField(value="specify")
    private  String specify; // 具体说明
    @TableField(value="file_urls")
    private  String fileUrls; // 招标文件
    @TableField(value="opportunity_id")
    private  Long opportunityId; // 工程主键
    @TableField(value="org_id")
    private  Long orgId; // 组织
    @TableField(value="org_name")
    private  String orgName; // 组织名称
    @TableField(value="maker_id")
    private  Long makerId; // 编制人主键
    @TableField(value="maker_name")
    private  String makerName; // 编制人名称
    @TableField(value="make_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate;//编制日期

    @TableField(value="open_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date openDate; // 开标日期
    @TableField(value="highest_mny")
    private BigDecimal highestMny; // 最高限价
    @TableField(value="bid_method")
    private String bidMethod; // 评标办法
    @TableField(value="teder_type")
    private String tederType; // 标书形式
    @TableField(value="bid_representative")
    private String bidRepresentative; // 招标代表


    @TableField(exist=false)
    @SubEntity(serviceName="inviteCompanyService", pidName = "inviteId")
    private List<InviteCompanyEntity> companyList = new ArrayList<>(); // 招标文件评审企业资质要求实体
    @TableField(exist=false)
    @SubEntity(serviceName="invitePersonService", pidName = "inviteId")
    private List<InvitePersonEntity> personList = new ArrayList<>(); // 招标文件评审人员资质要求实体


    /**
     * 单据编号
     */
    public  String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode( String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程名称
     */
    public  String getOpportunityName() {
        return opportunityName;
    }

    /**
     * 工程名称
     */
    public void setOpportunityName( String opportunityName) {
        this.opportunityName = opportunityName;
    }
    /**
     * 招标保证金
     */
    public BigDecimal getBondMny() {
        return bondMny;
    }

    /**
     * 招标保证金
     */
    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    /**
     * 招标时间
     */
    public java.util.Date getInviteDate() {
        return inviteDate;
    }

    /**
     * 招标时间
     */
    public void setInviteDate(java.util.Date inviteDate) {
        this.inviteDate = inviteDate;
    }
    /**
     * 单据状态
     */
    public  Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState( Integer billState) {
        this.billState = billState;
    }
    /**
     * 具体说明
     */
    public  String getSpecify() {
        return specify;
    }

    /**
     * 具体说明
     */
    public void setSpecify( String specify) {
        this.specify = specify;
    }
    /**
     * 招标文件
     */
    public  String getFileUrls() {
        return fileUrls;
    }

    /**
     * 招标文件
     */
    public void setFileUrls( String fileUrls) {
        this.fileUrls = fileUrls;
    }
    /**
     * 工程主键
     */
    public  Long getOpportunityId() {
        return opportunityId;
    }

    /**
     * 工程主键
     */
    public void setOpportunityId( Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    /**
     * 组织
     */
    public  Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId( Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public  String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName( String orgName) {
        this.orgName = orgName;
    }
    /**
     * 编制人主键
     */
    public  Long getMakerId() {
        return makerId;
    }

    /**
     * 编制人主键
     */
    public void setMakerId( Long makerId) {
        this.makerId = makerId;
    }
    /**
     * 编制人名称
     */
    public  String getMakerName() {
        return makerName;
    }

    /**
     * 编制人名称
     */
    public void setMakerName( String makerName) {
        this.makerName = makerName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public Date getOpenDate() {
        return openDate;
    }

    public void setOpenDate(Date openDate) {
        this.openDate = openDate;
    }

    public BigDecimal getHighestMny() {
        return highestMny;
    }

    public void setHighestMny(BigDecimal highestMny) {
        this.highestMny = highestMny;
    }

    public String getBidMethod() {
        return bidMethod;
    }

    public void setBidMethod(String bidMethod) {
        this.bidMethod = bidMethod;
    }

    public String getTederType() {
        return tederType;
    }

    public void setTederType(String tederType) {
        this.tederType = tederType;
    }

    public String getBidRepresentative() {
        return bidRepresentative;
    }

    public void setBidRepresentative(String bidRepresentative) {
        this.bidRepresentative = bidRepresentative;
    }

    public List<InviteCompanyEntity> getCompanyList() {
        return companyList;
    }

    public void setCompanyList(List<InviteCompanyEntity> companyList) {
        this.companyList = companyList;
    }

    public List<InvitePersonEntity> getPersonList() {
        return personList;
    }

    public void setPersonList(List<InvitePersonEntity> personList) {
        this.personList = personList;
    }
}
