package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.CertApplyDetailEntity;
import com.ejianc.business.oa.service.ICertApplyDetailService;
import com.ejianc.business.oa.vo.CertApplyDetailVO;

/**
 * 证照使用申请实体明细
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("certApplyDetail")
public class CertApplyDetailController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ICertApplyDetailService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertApplyDetailVO> saveOrUpdate(@RequestBody CertApplyDetailVO saveorUpdateVO) {
    	CertApplyDetailEntity entity = BeanMapper.map(saveorUpdateVO, CertApplyDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	CertApplyDetailVO vo = BeanMapper.map(entity, CertApplyDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertApplyDetailVO> queryDetail(Long id) {
    	CertApplyDetailEntity entity = service.selectById(id);
    	CertApplyDetailVO vo = BeanMapper.map(entity, CertApplyDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertApplyDetailVO> vos) {
        service.removeByIds(vos.stream().map(CertApplyDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description  忽略
     */
    @RequestMapping(value = "/ignore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> ignore(Long id) {
        LambdaUpdateWrapper<CertApplyDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(CertApplyDetailEntity::getId,id);
        updateWrapper.set(CertApplyDetailEntity::getDealStatus, 1);
        boolean ignore = service.update(updateWrapper);
        if (!ignore) {
            throw new BusinessException("网络异常，忽略失败，请稍后再试");
        }
        return CommonResponse.success("忽略成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CertApplyDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<CertApplyDetailEntity> page = service.queryPage(param,false);
        IPage<CertApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertApplyDetailVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
