package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.bean.WeeklyReportManagerEntity;
import com.ejianc.business.oa.controller.query.WeeklyReportQuery;
import com.ejianc.business.oa.service.IWeeklyReportManagerService;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.oa.service.impl.WeeklyReportServiceImpl;
import com.ejianc.business.oa.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周报
 *
 * @author generator
 */
@Controller
@RequestMapping("weeklyReport")
public class WeeklyReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWeeklyReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> saveOrUpdate(@RequestBody WeeklyReportVO weeklyReportVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(weeklyReportVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> queryDetail(Long id) {
        WeeklyReportEntity entity = service.selectById(id);
        WeeklyReportVO vo = BeanMapper.map(entity, WeeklyReportVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param projectId
     * @Description afterProject 项目编辑后
     */
    @RequestMapping(value = "/afterProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeeklyReportVO> afterProject(@RequestParam(value = "id", required = false) Long id, @RequestParam(value = "projectId") Long projectId,
                                                       @RequestParam(value = "weeklyNum", required = false) Integer weeklyNum) {
        return CommonResponse.success("查询项目编辑后数据成功！", service.afterProject(id, projectId, weeklyNum));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeeklyReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WeeklyReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WeeklyReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectDirectorName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<WeeklyReportEntity> page = service.queryPage(param, false);
        IPage<WeeklyReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeeklyReportVO.class));
        List<WeeklyReportVO> records = pageData.getRecords();
//        if (CollectionUtils.isNotEmpty(records)) {
//            for (WeeklyReportVO vo : records) {
//                Map<String, Object> result = service.selectStartWorkReportTimeAndTermByProjectId(vo.getProjectId());
//                if (result != null) {
//                    String startWorkReportTime = (String) result.get("start_work_date");
//                    Long termLong = (Long) result.get("term");
//                    int term = termLong != null ? termLong.intValue() : 0; // 如果需要的话，提供默认值
//                    String newDateStr = "";
//                    if (StringUtils.isNotEmpty(startWorkReportTime)) {
//                        // 将字符串转换为LocalDate对象
//                        LocalDate date = LocalDate.parse(startWorkReportTime, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
//                        // 增加天数
//                        LocalDate newDate = date.plusDays(term);
//                        // 将LocalDate对象转换回字符串
//                        newDateStr = newDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
//                        vo.setStartWorkDate(startWorkReportTime);
//                        vo.setEndWorkDate(newDateStr);
//                    } else {
//                        vo.setStartWorkDate("");
//                        vo.setEndWorkDate("");
//                    }
//                }
//            }
//        }
        if (CollectionUtils.isNotEmpty(records)) {
        List<Long> projectIds = records.stream()
                .map(WeeklyReportVO::getProjectId)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        Map<Long, ProjectDurationVO> map = service.selectStartWorkReportTimeAndTermByProjectId(projectIds);
            for (WeeklyReportVO vo : records) {
                Long projectId = vo.getProjectId();
                if (projectId != null && map.containsKey(projectId)) {
                    ProjectDurationVO durationVO = map.get(projectId);
                    vo.setStartWorkDate(durationVO.getStartWorkDate());
                    vo.setEndWorkDate(durationVO.getEndWorkDate());
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<WeeklyReportVO>> commonResponse = queryList(param);
        Map<String, Object> beans = new HashMap<>();
        List<WeeklyReportVO> records = commonResponse.getData().getRecords();
        records.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", records);
        ExcelExport.getInstance().export("WeeklyReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWeeklyReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> refWeeklyReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WeeklyReportEntity> page = service.queryPage(param, false);
        IPage<WeeklyReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeeklyReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryReportList(@RequestBody  WeeklyReportQuery query) {
        return CommonResponse.success("查询周报报表成功!", service.queryReportList(query));
    }

    @RequestMapping(value = "excelExportReport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportReport(@RequestBody WeeklyReportQuery query, HttpServletResponse response) throws IOException {
        query.setDisAblePage(true);
        CommonResponse<IPage<WeeklyReportVO>> voPage = queryReportList(query);
        List<WeeklyReportVO> list = voPage.getData().getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        Workbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        /** 冻结前三行 */
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 19));

        //首行标题
        Row row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        style.setBorderLeft((short) 1);
        style.setBorderRight((short) 1);
        style.setBorderBottom((short) 1);
        style.setBorderTop((short) 1);

        DataFormat dataFormat = workbook.createDataFormat();
        // 1. 定义数据格式（格式字符串 "0.000000" 表示强制显示 6 位小数）
        CellStyle style6 = workbook.createCellStyle();
//        style6.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
//        style6.setFillPattern(CellStyle.SOLID_FOREGROUND);
//        style6.setAlignment(CellStyle.ALIGN_CENTER);
//        style6.setBorderLeft((short) 1);
//        style6.setBorderRight((short) 1);
//        style6.setBorderBottom((short) 1);
//        style6.setBorderTop((short) 1);
        style6.setDataFormat(dataFormat.getFormat("0.000000"));

        //2.定义数据格式（格式字符串 "0.00" 表示强制显示 2位小数）
        CellStyle style2 = workbook.createCellStyle();
//        style2.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
//        style2.setFillPattern(CellStyle.SOLID_FOREGROUND);
//        style2.setAlignment(CellStyle.ALIGN_CENTER);
//        style2.setBorderLeft((short) 1);
//        style2.setBorderRight((short) 1);
//        style2.setBorderBottom((short) 1);
//        style2.setBorderTop((short) 1);
        style2.setDataFormat(dataFormat.getFormat("0.00"));

        Cell cell = row.createCell(0);
        //Map<String, Parameter> params = param.getParams();
        //Parameter weeklyNum = params.get("weeklyNum");
        Integer weeklyNum = query.getWeeklyNum();

        cell.setCellValue("施工周报" + (weeklyNum != null ? "（第" + weeklyNum + "周）" : ""));
        cell.setCellStyle(style);
        for (int i = 1; i < 20; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
        }
        //第二行数据
        row = sheet.createRow(1);

        cell = row.createCell(0);
        cell.setCellValue("序号");
        cell.setCellStyle(style);

        cell = row.createCell(1);
        cell.setCellValue("项目总监");
        cell.setCellStyle(style);

        cell = row.createCell(2);
        cell.setCellValue("项目编码");
        cell.setCellStyle(style);

        cell = row.createCell(3);
        cell.setCellValue("项目名称");
        cell.setCellStyle(style);

        cell = row.createCell(4);
        cell.setCellValue("合同总金额(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(5);
        cell.setCellValue("合同暂列金(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(6);
        cell.setCellValue("第几周");
        cell.setCellStyle(style);

        cell = row.createCell(7);
        cell.setCellValue("上周进度(%)");
        cell.setCellStyle(style);

        cell = row.createCell(8);
        cell.setCellValue("本周进度(%)");
        cell.setCellStyle(style);

        cell = row.createCell(9);
        cell.setCellValue("合同开工日期(开工报告)");
        cell.setCellStyle(style);

        cell = row.createCell(10);
        cell.setCellValue("合同竣工日期");
        cell.setCellStyle(style);

        cell = row.createCell(11);
        cell.setCellValue("项目经理");
        cell.setCellStyle(style);

        cell = row.createCell(12);
        cell.setCellValue("本周完成产值(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(13);
        cell.setCellValue("项目人效(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(14);
        cell.setCellValue("区域每周产值(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(15);
        cell.setCellValue("区域每周平均人效(万元)");
        cell.setCellStyle(style);

        cell = row.createCell(16);
        cell.setCellValue("管理人员");
        cell.setCellStyle(style);

        cell = row.createCell(17);
        cell.setCellValue("项目人效系数");
        cell.setCellStyle(style);

        cell = row.createCell(18);
        cell.setCellValue("管理人员明细");
        cell.setCellStyle(style);

        cell = row.createCell(19);
        cell.setCellValue("施工人数");
        cell.setCellStyle(style);

        for (int i = 0; i < 20; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 35 / 13);
        }
        for (int i = 0; i < list.size(); i++) {
            WeeklyReportVO vo = list.get(i);
            row = sheet.createRow(i + 2);

            //list数据经过了projectDirector倒序排序、故合并项目总监对应的 项目总监名称、区域每周产值(万元）、区域每周平均人效可以进行单元格合并
            //rowSpan rowSpan如果大于0则表示当前的的行可以向下合并rowSpan的单元格行数 只会对项目总监名称、区域每周产值(万元）、区域每周平均人效这三项进行合并
            //normalRowSpan 表示不进行合并的行、但是要保持一致、默认都设置的1

            //例如 第3行 rowSpan = 2 normalRowSpan =1 则表示 第3行第1列会向下与第4行第1列单元格进行合并、第3行第12列会向下与第4行第12列合并、第3行第13列会向下与第4行第13列合并
            //例如 第4行 rowSpan = 0 normalRowSpan =1 则表示 第4行不进行向下合并、通常的单元格 第4行第0列、第4行第2列.....只进行值的设置 【CellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) 若firstRow和lastRow相等则不进行单元格合并】
            if (vo.getRowSpan() > 0) {
                Integer rowSpan = vo.getRowSpan();

                //项目总监
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));

                //区域每周产值(万元)
                cell = row.createCell(14);
                //cell.setCellValue(vo.getAreaOutputMny() == null ? "" : vo.getAreaOutputMny().setScale(6, RoundingMode.HALF_UP).toString());
                if (vo.getAreaOutputMny() != null){
                    // 使用 setScale 来保留小数位，并将 BigDecimal 转换为 double
                    cell.setCellValue(vo.getAreaOutputMny().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }

                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 14, 14));

                //区域每周平均人效(万元)
                cell = row.createCell(15);
                //cell.setCellValue(vo.getAreaPersonEfficiency() == null ? "" : vo.getAreaPersonEfficiency().setScale(6, RoundingMode.HALF_UP).toString());
                if (vo.getAreaPersonEfficiency() != null){
                    // 使用 setScale 来保留小数位，并将 BigDecimal 转换为 double
                    cell.setCellValue(vo.getAreaPersonEfficiency().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 15, 15));
            }
            if (vo.getNormalRowSpan() > 0) {
                Integer rowSpan = vo.getNormalRowSpan();

                //序号
                cell = row.createCell(0);
                cell.setCellValue((i + 1)+ "");
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));

                //项目编码
                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectCode() == null ? "" : vo.getProjectCode());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));

                //项目名称
                cell = row.createCell(3);
                cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));

                //合同总金额(万元)
                cell = row.createCell(4);
                //cell.setCellValue(vo.getCostTotalMny() == null ? "" : vo.getCostTotalMny().setScale(2, RoundingMode.HALF_UP).toString());
                if (vo.getCostTotalMny() != null) {
                    cell.setCellValue(vo.getCostTotalMny().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                //合同暂列金(万元)
                cell = row.createCell(5);
                //cell.setCellValue(vo.getContractTempMny() == null ? "" : vo.getContractTempMny().setScale(2, RoundingMode.HALF_UP).toString());
                if (vo.getContractTempMny() != null) {
                    cell.setCellValue(vo.getContractTempMny().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 5, 5));

                //第几周
                cell = row.createCell(6);
                //cell.setCellValue(vo.getWeeklyNum() == null ? "" : vo.getWeeklyNum().toString());
                if (vo.getWeeklyNum() != null) {
                    cell.setCellValue(vo.getWeeklyNum());
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 6, 6));

                //上周进度(%)
                cell = row.createCell(7);
                cell.setCellValue(vo.getLastWeeklyProgress() == null ? "" : vo.getLastWeeklyProgress().setScale(2, RoundingMode.HALF_UP) + "%");
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 7, 7));

                //本周进度(%)
                cell = row.createCell(8);
                cell.setCellValue(vo.getWeeklyProgress() == null ? "" : vo.getWeeklyProgress().setScale(2, RoundingMode.HALF_UP) + "%");
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 8, 8));

                //合同开工日期(开工报告)
                cell = row.createCell(9);
                cell.setCellValue(vo.getStartWorkDate() == null ? "": vo.getStartWorkDate());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 9, 9));

                //合同竣工日期
                cell = row.createCell(10);
                cell.setCellValue(vo.getEndWorkDate() == null ? "" : vo.getEndWorkDate());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 10, 10));

                //项目经理
                cell = row.createCell(11);
                cell.setCellValue(vo.getProjectManagerName() == null ? "" : vo.getProjectManagerName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 11, 11));

                //本周完成产值(万元)
                cell = row.createCell(12);
                //cell.setCellValue(vo.getFinishOutputMny() == null ? "" : vo.getFinishOutputMny().setScale(6, RoundingMode.HALF_UP).toString());
                if (vo.getFinishOutputMny() != null) {
                    // 使用 setScale 来保留小数位，并将 BigDecimal 转换为 double
                    cell.setCellValue(vo.getFinishOutputMny().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 12, 12));

                //项目人效(万元)
                cell = row.createCell(13);
                //cell.setCellValue(vo.getProjPersonEfficiency() == null ? "" : vo.getProjPersonEfficiency().setScale(6, RoundingMode.HALF_UP).toString());
                if (vo.getProjPersonEfficiency() != null) {
                    // 使用 setScale 来保留小数位，并将 BigDecimal 转换为 double
                    cell.setCellValue(vo.getProjPersonEfficiency().setScale(6, RoundingMode.HALF_UP).doubleValue());
                    cell.setCellStyle(style6);
                }
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 13, 13));

                //管理人员
                cell = row.createCell(16);
                cell.setCellValue(vo.getManagePersonNum() == null ? "" : vo.getManagePersonNum().setScale(0, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 16, 16));

                // 项目人效系数
                cell = row.createCell(17);
                cell.setCellValue(vo.getEfficiencyCoefficientSum() == null ? "" : vo.getEfficiencyCoefficientSum().setScale(2, RoundingMode.HALF_UP).toString());

                //管理人员明细
                cell = row.createCell(18);
                cell.setCellValue(vo.getManagerList() == null ? "" : vo.getManagerList().stream().map(WeeklyReportManagerVO::getName).collect(Collectors.joining(",")));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 17, 17));

                //施工人数
                cell = row.createCell(19);
                cell.setCellValue(vo.getConstructionPersonNum() == null ? "" : vo.getConstructionPersonNum().setScale(0, RoundingMode.HALF_UP).toString());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 18, 18));
            }
        }
        workbook.write(outputStream);
    }


    @RequestMapping(value = "queryProblemList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportVO>> queryProblemList(@RequestBody QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("projectDirectorName", "projectCode", "projectName"));
        return CommonResponse.success("查询周问题报表成功!", service.queryProblemList(param));
    }

    @RequestMapping(value = "excelExportProblem", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportProblem(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(-1);
        param.setPageIndex(1);
        param.getFuzzyFields().addAll(Arrays.asList("projectDirectorName", "projectCode", "projectName"));
        CommonResponse<IPage<WeeklyReportVO>> voPage = queryProblemList(param);
        List<WeeklyReportVO> list = voPage.getData().getRecords();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        /** 冻结前三行 */
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 15));

        //首行标题
        XSSFRow row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        style.setBorderLeft((short) 1);
        style.setBorderRight((short) 1);
        style.setBorderBottom((short) 1);
        style.setBorderTop((short) 1);
        XSSFCell cell = row.createCell(0);
        Map<String, Parameter> params = param.getParams();
        Parameter weeklyNum = params.get("weeklyNum");
        cell.setCellValue("周问题报表" + (weeklyNum != null ? "（第" + weeklyNum.getValue().toString() + "周）" : ""));
        cell.setCellStyle(style);
        for (int i = 1; i < 16; i++) {
            cell = row.createCell(i);
            cell.setCellStyle(style);
        }
        //第二行数据
        row = sheet.createRow(1);
        cell = row.createCell(0);
        cell.setCellValue("区域");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("项目编码");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("项目名称");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("第几周");
        cell.setCellStyle(style);

        cell = row.createCell(4);
        cell.setCellValue("物料方面问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("物料方面措施");
        cell.setCellStyle(style);

        cell = row.createCell(6);
        cell.setCellValue("班组方面问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("班组方面措施");
        cell.setCellStyle(style);

        cell = row.createCell(8);
        cell.setCellValue("样板间施工问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("样板间施工措施");
        cell.setCellStyle(style);

        cell = row.createCell(10);
        cell.setCellValue("现场方案问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(11);
        cell.setCellValue("现场方案措施");
        cell.setCellStyle(style);

        cell = row.createCell(12);
        cell.setCellValue("合同方面问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(13);
        cell.setCellValue("合同方面措施");
        cell.setCellStyle(style);

        cell = row.createCell(14);
        cell.setCellValue("其他问题描述");
        cell.setCellStyle(style);
        cell = row.createCell(15);
        cell.setCellValue("其他问题措施");
        cell.setCellStyle(style);

        for (int i = 0; i < 16; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 10 / 4);
        }
        for (int i = 0; i < list.size(); i++) {
            WeeklyReportVO vo = list.get(i);
            row = sheet.createRow(i + 2);
            if (vo.getRowSpan() > 0) {
                Integer rowSpan = vo.getRowSpan();
                cell = row.createCell(0);
                cell.setCellValue(vo.getProjectDirectorName() == null ? "" : vo.getProjectDirectorName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 0, 0));
            }
            if (vo.getNormalRowSpan() > 0) {
                Integer rowSpan = vo.getNormalRowSpan();
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectCode() == null ? "" : vo.getProjectCode());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));

                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() == null ? "" : vo.getProjectName());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 1, 1));

                cell = row.createCell(3);
                cell.setCellValue(vo.getWeeklyNum() == null ? "" : String.valueOf(vo.getWeeklyNum().intValue()));
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 2, 2));

                cell = row.createCell(4);
                cell.setCellValue(vo.getMaterialProblem() == null ? "" : vo.getMaterialProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(5);
                cell.setCellValue(vo.getMaterialMeasure() == null ? "" : vo.getMaterialMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(6);
                cell.setCellValue(vo.getTeamProblem() == null ? "" : vo.getTeamProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(7);
                cell.setCellValue(vo.getTeamMeasure() == null ? "" : vo.getTeamMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(8);
                cell.setCellValue(vo.getRoomProblem() == null ? "" : vo.getRoomProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(9);
                cell.setCellValue(vo.getRoomMeasure() == null ? "" : vo.getRoomMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(10);
                cell.setCellValue(vo.getSceneProblem() == null ? "" : vo.getSceneProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(11);
                cell.setCellValue(vo.getSceneMeasure() == null ? "" : vo.getSceneMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(12);
                cell.setCellValue(vo.getContractProblem() == null ? "" : vo.getContractProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(13);
                cell.setCellValue(vo.getContractMeasure() == null ? "" : vo.getContractMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));

                cell = row.createCell(14);
                cell.setCellValue(vo.getOtherProblem() == null ? "" : vo.getOtherProblem());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 3, 3));
                cell = row.createCell(15);
                cell.setCellValue(vo.getOtherMeasure() == null ? "" : vo.getOtherMeasure());
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + rowSpan - 1, 4, 4));
            }
        }
        workbook.write(outputStream);
    }

    /**
     * description：查询当前实际本周数
     *
     * @param query
     * @return {@code CommonResponse<Integer> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryWeeklyNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Integer> queryWeeklyNum(@RequestBody WeeklyReportQuery query) {
        return CommonResponse.success("查询周问题报表成功!", service.queryWeeklyNum(query));
    }

    /**
     * description：根据projectId查询项目年度指标计划的”年度计划产值“字段
     *
     * @param projectId
     * @return {@code CommonResponse<BigDecimal> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryPlanOutputByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> queryPlanOutputByProjectId(Long projectId) {
        return CommonResponse.success("查询年度计划产值成功!", service.queryPlanOutputByProjectId(projectId));
    }

    /**
     * description：根据projectId查询开工报告
     *
     * @param projectId
     * @return {@code CommonResponse<BigDecimal> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryStartWorkReportByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MarketStartWorkReportVO> queryStartWorkReportByProjectId(Long projectId) {
        return CommonResponse.success("查询开工报告!", service.queryStartWorkReportByProjectId(projectId));
    }

    /**
     * description：根据projectId查询项目年度指标计划
     *
     * @param projectId
     * @return {@code CommonResponse<BigDecimal> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryReturnPlanByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HkReturnPlanVO> queryReturnPlanByProjectId(Long projectId) {
        return CommonResponse.success("查询年度指标计划成功!", service.queryReturnPlanByProjectId(projectId));
    }

    /**
     * description：根据projectId查询收款登记
     *
     * @param projectId
     * @return {@code CommonResponse<BigDecimal> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryReceiveByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinanceReceiveVO> queryReceiveByProjectId(Long projectId) {
        return CommonResponse.success("查询收款登记成功!", service.queryReceiveByProjectId(projectId));
    }

    /**
     * description：根据projectId查询项目管理人员及责任分工2.0
     *
     * @param projectId
     * @return {@code CommonResponse<BigDecimal> }
     * @author niexiang
     * @date 2025/03/06
     */
    @RequestMapping(value = "queryProjectManagerByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WeeklyProjectManagerVO>> queryProjectManagerByProjectId(Long projectId) {
        return CommonResponse.success("查询项目管理人员成功!", service.queryProjectManagerByProjectId(projectId));
    }

}
