package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.oa.vo.CertApplyListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.CertApplyEntity;
import com.ejianc.business.oa.service.ICertApplyService;
import com.ejianc.business.oa.vo.CertApplyVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 证照使用申请实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("certApply")
public class CertApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICertApplyService service;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertApplyVO> saveOrUpdate(@RequestBody CertApplyVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);

    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertApplyVO> queryDetail(Long id) {
        CertApplyEntity entity = service.selectById(id);
        CertApplyVO vo = BeanMapper.map(entity, CertApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertApplyVO> vos) {
        service.removeByIds(vos.stream().map(CertApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CertApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("certName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applierName");
        fuzzyFields.add("departmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<CertApplyEntity> page = service.queryPage(param, false);
        IPage<CertApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 待处理列表
     */
    @PostMapping("/getDealList")
    @ResponseBody
    public CommonResponse<JSONObject> getDealList(@RequestBody QueryParam param) {
        //3、搜索：1、证照编号 ； 2、证照名称；3、申请编号；4、申请人，5、用途；
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("applierName");
        fuzzyFields.add("memo");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = param.getParams().get("certTypeId");
                Object certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue(certTypeIdOrg + "," + certTypeId);
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }

        Page<CertApplyListVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CertApplyListVO> list = service.getDealList(page,wrapper);
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);


    }
}
