package com.ejianc.business.procBid.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class ProcBidReportVO {
    private Long id; //id
    private Long purchaseId; //采购事项ID
    private String purchaseCode; //采购事项CODE
    private String purchaseName; //采购事项NAME
    private Long projectId; //项目ID
    private String projectCode; //项目CODE
    private String projectName; //项目NAME
    private String procType; //招采类型
    private String profession; //专业
    private String procCategory; //招采品类
    private BigDecimal estimatedMny; //预估标的物金额

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planArrivalTime; //计划到货/进场时间
    private Integer estPrepDay; //预计货期/进场准备（天）

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBidTime; //计划定标时间
    private Integer remainDay; //剩余时间（天）

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date supplierApprovedTime; //单位入围审批通过时间
    private Long supplierApprovalId; //单位入围ID

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date bidDocApprovedTime; //招标文件审批通过时间
    private Long bidDocId; //招标文件ID

    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date bidApprovedTime; //定标单位审批通过时间
    private Long bidApprovalId; //定标单位ID
    private BigDecimal winningMny; //定标金额

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseCode() {
        return purchaseCode;
    }

    public void setPurchaseCode(String purchaseCode) {
        this.purchaseCode = purchaseCode;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProcType() {
        return procType;
    }

    public void setProcType(String procType) {
        this.procType = procType;
    }

    public String getProfession() {
        return profession;
    }

    public void setProfession(String profession) {
        this.profession = profession;
    }

    public String getProcCategory() {
        return procCategory;
    }

    public void setProcCategory(String procCategory) {
        this.procCategory = procCategory;
    }

    public BigDecimal getEstimatedMny() {
        return estimatedMny;
    }

    public void setEstimatedMny(BigDecimal estimatedMny) {
        this.estimatedMny = estimatedMny;
    }

    public Date getPlanArrivalTime() {
        return planArrivalTime;
    }

    public void setPlanArrivalTime(Date planArrivalTime) {
        this.planArrivalTime = planArrivalTime;
    }

    public Integer getEstPrepDay() {
        return estPrepDay;
    }

    public void setEstPrepDay(Integer estPrepDay) {
        this.estPrepDay = estPrepDay;
    }

    public Date getPlanBidTime() {
        return planBidTime;
    }

    public void setPlanBidTime(Date planBidTime) {
        this.planBidTime = planBidTime;
    }

    public Integer getRemainDay() {
        return remainDay;
    }

    public void setRemainDay(Integer remainDay) {
        this.remainDay = remainDay;
    }

    public Date getSupplierApprovedTime() {
        return supplierApprovedTime;
    }

    public void setSupplierApprovedTime(Date supplierApprovedTime) {
        this.supplierApprovedTime = supplierApprovedTime;
    }

    public Long getSupplierApprovalId() {
        return supplierApprovalId;
    }

    public void setSupplierApprovalId(Long supplierApprovalId) {
        this.supplierApprovalId = supplierApprovalId;
    }

    public Date getBidDocApprovedTime() {
        return bidDocApprovedTime;
    }

    public void setBidDocApprovedTime(Date bidDocApprovedTime) {
        this.bidDocApprovedTime = bidDocApprovedTime;
    }

    public Long getBidDocId() {
        return bidDocId;
    }

    public void setBidDocId(Long bidDocId) {
        this.bidDocId = bidDocId;
    }

    public Date getBidApprovedTime() {
        return bidApprovedTime;
    }

    public void setBidApprovedTime(Date bidApprovedTime) {
        this.bidApprovedTime = bidApprovedTime;
    }

    public Long getBidApprovalId() {
        return bidApprovalId;
    }

    public void setBidApprovalId(Long bidApprovalId) {
        this.bidApprovalId = bidApprovalId;
    }

    public BigDecimal getWinningMny() {
        return winningMny;
    }

    public void setWinningMny(BigDecimal winningMny) {
        this.winningMny = winningMny;
    }
}