package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WorkLogEntity;
import com.ejianc.business.oa.mapper.WorkLogMapper;
import com.ejianc.business.oa.service.IWorkLogService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.*;

/**
 * 施工日志
 *
 * @author generator
 *
 */
@Service("workLogService")
public class WorkLogServiceImpl extends BaseServiceImpl<WorkLogMapper, WorkLogEntity> implements IWorkLogService {

    @Override
    public List<JSONObject> queryWorkTeamReport(Page<JSONObject> page, QueryWrapper wrapper, String monthDate) {
        ArrayList<Integer> days = new ArrayList<>();
        // 获取月份的天数
        int daysInMonth = LocalDate.parse(monthDate + "-01").lengthOfMonth();
        for (int i = 1; i <= daysInMonth; i++) {
            days.add(i);
        }
        List<JSONObject> list = baseMapper.queryWorkTeamReport(page, wrapper, days);
        if (CollectionUtils.isNotEmpty(list)) {
            for (JSONObject jsonObject : list) {
                int total = 0;
                for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                    if (entry.getKey().contains("num")) {
                        int value = entry.getValue() != null ? Integer.parseInt(entry.getValue().toString()) : 0;
                        total += value;
                    }
                }
                jsonObject.put("total_num", total);
            }
        }
        return list;
    }

}
