package com.ejianc.business.procBid.controller;

import java.io.Serializable;

import com.ejianc.business.home.util.ParamUtil;
import com.ejianc.business.procBid.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.procBid.bean.ProcReportManagerEntity;
import com.ejianc.business.procBid.service.IProcReportManagerService;
import com.ejianc.business.procBid.vo.ProcReportManagerVO;

/**
 * 采购招标立项申请审批表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("procReportManager")
public class ProcReportManagerController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CGSP";//此处需要根据实际修改

    @Autowired
    private IProcReportManagerService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProcReportManagerVO> saveOrUpdate(@RequestBody ProcReportManagerVO saveOrUpdateVO) {
    	ProcReportManagerEntity entity = BeanMapper.map(saveOrUpdateVO, ProcReportManagerEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ProcReportManagerVO vo = BeanMapper.map(entity, ProcReportManagerVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProcReportManagerVO> queryDetail(Long id) {
    	ProcReportManagerEntity entity = service.selectById(id);
    	ProcReportManagerVO vo = BeanMapper.map(entity, ProcReportManagerVO.class);
        // 获取当前时间
        Date currentTime = new Date();
        // 调用工具类计算剩余天数
        int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
        // 赋值给实体的remainDay字段
        vo.setRemainDay(remainDay);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProcReportManagerVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProcReportManagerVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ProcReportManagerVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("purchaseItem");
        fuzzyFields.add("profession");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            //移动端查询
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            //pc端查询
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProcReportManagerEntity> page = service.queryPage(param,false);
        // 获取当前时间
        Date currentTime = new Date();
        page.getRecords().forEach(item -> {
            // 调用工具类计算剩余天数
            int remainDay = DateUtils.getDaysBetween(item.getPlanBidTime(), currentTime);
            // 赋值给实体的remainDay字段
            item.setRemainDay(remainDay);
        });
        IPage<ProcReportManagerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProcReportManagerVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("purchaseItem");
        fuzzyFields.add("profession");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProcReportManagerEntity> list = service.queryList(param);
        // 获取当前时间
        Date currentTime = new Date();
        list.forEach(vo -> {
            switch (vo.getProcType()) {
                case "1":
                    vo.setProcType("单项目招标");
                    break;
                case "2":
                    vo.setProcType("集采招标");
                    break;
                default:
                    vo.setProcType("");
                    break;
            }

            // 调用工具类计算剩余天数
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            // 赋值给实体的remainDay字段
            vo.setRemainDay(remainDay);
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("ProcReportManager-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProcReportManagerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> refProcReportManagerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "purchaseItem", "profession"));
        // 添加倒序排列
        param.getOrderMap().put("createTime", QueryParam.DESC);
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        String sql = ParamUtil.getSql(param,"T");
        IPage<ProcReportManagerVO> page = new Page<>(pageNumber, pageSize);
        List<ProcReportManagerVO> list = service.refProcReportManagerData(page,sql);
        // 获取当前时间
        Date currentTime = new Date();
        // 数据处理
        list.forEach(vo -> {
            // 调用工具类计算剩余天数
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            // 赋值给实体的remainDay字段
            vo.setRemainDay(remainDay);
        });

        page.setRecords(BeanMapper.mapList(list, ProcReportManagerVO.class));

        return CommonResponse.success("查询参照数据成功！",page);
     }

    /**
     * @Description 参照 （物资设备类定标会签使用）
     * @Return void
     */
    @RequestMapping(value = "/refProcReportManagerDataHQ", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> refProcReportManagerDataHQ(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3))); //审批通过
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "purchaseItem", "profession"));

        String sql = ParamUtil.getSql(param,"T");
        IPage<ProcReportManagerVO> page = new Page<>(pageNumber, pageSize);
        List<ProcReportManagerVO> list = service.refProcReportManagerDataHQ(page,sql);
        // 获取当前时间
        Date currentTime = new Date();
        // 数据处理
        list.forEach(vo -> {
            // 调用工具类计算剩余天数
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            // 赋值给实体的remainDay字段
            vo.setRemainDay(remainDay);
        });
        page.setRecords(list);
        return CommonResponse.success("查询参照数据成功！",page);
     }
}
