package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.BidDetailEntity;
import com.ejianc.business.oa.bean.BidEntity;
import com.ejianc.business.oa.service.IBidService;
import com.ejianc.business.oa.vo.AwardVO;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.AwardMapper;
import com.ejianc.business.oa.bean.AwardEntity;
import com.ejianc.business.oa.service.IAwardService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 奖项实体
 * 
 * @author generator
 * 
 */
@Service("awardService")
public class AwardServiceImpl extends BaseServiceImpl<AwardMapper, AwardEntity> implements IAwardService{
    @Autowired
    private IAwardService service;

    @Override
    public List<AwardVO> queryAwardByProjectId(Long projectId) {
        LambdaQueryWrapper<AwardEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(AwardEntity::getProjectId,projectId);
        lambdaQueryWrapper.in(AwardEntity::getBillState,1,3);
        lambdaQueryWrapper.eq(AwardEntity::getDr,0);
        List<AwardEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return  null;

        }
        list.forEach(v->v.setEmployeeId(null));
        return  BeanMapper.mapList(list, AwardVO.class);
    }
}
