package com.ejianc.business.oa.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标文件评审实体
 *
 * @author generator
 *
 */
public class BidVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Long opportunityId; // 工程主键
    private java.lang.String opportunityName; // 工程名称
    private java.lang.Long engineeringType; // 工程类型
    private java.lang.String engineeringTypeName; // 工程类型名称
    private java.lang.Long employeeId; // 项目经理主键
    private java.lang.String employeeName; // 项目经理
    private java.math.BigDecimal offerMny; // 报价
    private java.math.BigDecimal bondMny; // 投标保证金
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date bidDate; // 开标日期
    private java.math.BigDecimal bidMny; // 投标金额
    private java.lang.String content; // 投标内容
    private java.lang.Integer billState; // 单据状态
    private java.lang.String fileUrls; // 投标文件
    private java.lang.Long orgId; // 所属组织
    private java.lang.String orgName; // 组织名称
    private java.lang.Long makerId; // 编制人主键
    private java.lang.String makerName; // 编制人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate;
    private BigDecimal highestMny; // 最高限价

    private List<BidDetailVO> detailList = new ArrayList<>(); // 投标文件评审子实体

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程主键
     */
    @ReferSerialTransfer(referCode="business-opportunity-register")
    public java.lang.Long getOpportunityId() {
        return opportunityId;
    }

    /**
     * 工程主键
     */
    @ReferDeserialTransfer
    public void setOpportunityId(java.lang.Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    /**
     * 工程名称
     */
    public java.lang.String getOpportunityName() {
        return opportunityName;
    }

    /**
     * 工程名称
     */
    public void setOpportunityName(java.lang.String opportunityName) {
        this.opportunityName = opportunityName;
    }
    /**
     * 工程类型
     */
    public java.lang.Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类型
     */
    public void setEngineeringType(java.lang.Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类型名称
     */
    public java.lang.String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName(java.lang.String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 项目经理主键
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 项目经理主键
     */
    @ReferDeserialTransfer
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 项目经理
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 项目经理
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 报价
     */
    public java.math.BigDecimal getOfferMny() {
        return offerMny;
    }

    /**
     * 报价
     */
    public void setOfferMny(java.math.BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    /**
     * 投标保证金
     */
    public java.math.BigDecimal getBondMny() {
        return bondMny;
    }

    /**
     * 投标保证金
     */
    public void setBondMny(java.math.BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    /**
     * 开标日期
     */
    public java.util.Date getBidDate() {
        return bidDate;
    }

    /**
     * 开标日期
     */
    public void setBidDate(java.util.Date bidDate) {
        this.bidDate = bidDate;
    }
    /**
     * 投标金额
     */
    public java.math.BigDecimal getBidMny() {
        return bidMny;
    }

    /**
     * 投标金额
     */
    public void setBidMny(java.math.BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    /**
     * 投标内容
     */
    public java.lang.String getContent() {
        return content;
    }

    /**
     * 投标内容
     */
    public void setContent(java.lang.String content) {
        this.content = content;
    }
    /**
     * 单据状态
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 投标文件
     */
    public java.lang.String getFileUrls() {
        return fileUrls;
    }

    /**
     * 投标文件
     */
    public void setFileUrls(java.lang.String fileUrls) {
        this.fileUrls = fileUrls;
    }
    /**
     * 所属组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 编制人主键
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getMakerId() {
        return makerId;
    }

    /**
     * 编制人主键
     */
    @ReferDeserialTransfer
    public void setMakerId(java.lang.Long makerId) {
        this.makerId = makerId;
    }
    /**
     * 编制人名称
     */
    public java.lang.String getMakerName() {
        return makerName;
    }

    /**
     * 编制人名称
     */
    public void setMakerName(java.lang.String makerName) {
        this.makerName = makerName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public BigDecimal getHighestMny() {
        return highestMny;
    }

    public void setHighestMny(BigDecimal highestMny) {
        this.highestMny = highestMny;
    }

    public List<BidDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BidDetailVO> detailList) {
        this.detailList = detailList;
    }
}
