/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.MattersApplyEntity;
import com.ejianc.business.oa.service.IMattersApplyService;
import com.ejianc.business.oa.vo.MattersApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mattersApply"})
public class MattersApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MATTERS_APPLY_BILL_CODE = "MATTERS_APPLY";
    private static final String PARAM_VIEW_CODE = "P-67W0Aq73";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMattersApplyService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MattersApplyVO> saveOrUpdate(@RequestBody MattersApplyVO saveOrUpdateVO) {
        MattersApplyEntity entity = (MattersApplyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MattersApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(MATTERS_APPLY_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MattersApplyVO vo = (MattersApplyVO)((Object)BeanMapper.map((Object)((Object)entity), MattersApplyVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MattersApplyVO> queryDetail(Long id) {
        MattersApplyEntity entity = (MattersApplyEntity)((Object)this.service.selectById(id));
        MattersApplyVO vo = (MattersApplyVO)((Object)BeanMapper.map((Object)((Object)entity), MattersApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MattersApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MattersApplyVO mattersApplyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MattersApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        System.out.println(this.sessionManager.getUserContext().getEmployeeId());
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MattersApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List mattersApplyVOS = BeanMapper.mapList((Iterable)list, MattersApplyVO.class);
        if (CollectionUtils.isNotEmpty((Collection)mattersApplyVOS)) {
            mattersApplyVOS.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", mattersApplyVOS);
        ExcelExport.getInstance().export("MattersApply-export.xlsx", beans, response);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/refMattersApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MattersApplyVO>> refMattersApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        UserContext userContext;
        String authOrgIds;
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"orgId")) {
            orgId = _con.getLong("orgId");
        }
        if (StringUtils.isNotEmpty((CharSequence)(authOrgIds = (userContext = this.sessionManager.getUserContext()).getAuthOrgIds()))) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (MapUtils.isEmpty((Map)param.getOrderMap())) {
            param.getOrderMap().put("createTime", "desc");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MattersApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

