package com.ejianc.business.procBid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.procBid.bean.ProcBidApprovalEntity;
import com.ejianc.business.procBid.bean.ProcReportManagerEntity;
import com.ejianc.business.procBid.bean.SupplierApprovalEntity;
import com.ejianc.business.procBid.service.IProcBidApprovalService;
import com.ejianc.business.procBid.service.ISupplierApprovalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("supplierApproval") 
public class SupplierApprovalBpmServiceImpl implements ICommonBusinessService {

	@Autowired
    private ISupplierApprovalService service;

	@Autowired
    private IProcBidApprovalService procBidApprovalService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 更新审批时间
		SupplierApprovalEntity entity = service.getById(billId);
		if(entity == null) {
			return CommonResponse.error("单据不存在！");
		}
		entity.setApprovedTime(new Date());
		service.saveOrUpdate(entity,false);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 更新审批时间
		SupplierApprovalEntity entity = service.getById(billId);
		if(entity == null) {
			return CommonResponse.error("单据不存在！");
		}
		// 查询"物资设备类定标会签"是否存在引用单据
		LambdaQueryWrapper<ProcBidApprovalEntity> query3 = new LambdaQueryWrapper<>();
		query3.eq(ProcBidApprovalEntity::getPurchaseId, entity.getPurchaseId());
		ProcBidApprovalEntity procBidApprovalEntity = procBidApprovalService.getOne(query3);
		if (procBidApprovalEntity != null) {
			String billCode = procBidApprovalEntity.getBillCode();
			return CommonResponse.error("单据被下游单据引用: " + billCode + "，请先删除被引用单据！");
		}
		//TODO
		return CommonResponse.success();
	}

}
