package com.ejianc.business.procBid.service.impl;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.checkerframework.checker.units.qual.A;

import com.ejianc.business.procBid.mapper.ProcBidReportMapper;
import com.ejianc.business.procBid.query.ProcBidReportQuery;
import com.ejianc.business.procBid.service.IProcBidReportService;
import com.ejianc.business.procBid.vo.ProcBidReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("ProcBidReportServiceImpl")
public class ProcBidReportServiceImpl implements IProcBidReportService {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private ProcBidReportMapper procBidReportMapper;

    @Override
    public IPage<ProcBidReportVO> queryProcBidReportList(ProcBidReportQuery query) {

        /** 租户隔离 */
        // query.xxx,是query里面的代码
        // InvocationInfoProxy这个是依赖里面的东西，跟着写就行了
        query.setTenantId(InvocationInfoProxy.getTenantid());

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        query.setOrgIdList(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        IPage<ProcBidReportVO> page = new Page<>(query.getPageNum(), query.getPageSize());
        List<ProcBidReportVO> result = new ArrayList<>();
        if (query.getDisAblePage()){
            result = procBidReportMapper.queryProcBidReportList(null, query);
        }else{
            result = procBidReportMapper.queryProcBidReportList(page, query);
        }

        // 设置分页
        page.setRecords(result);

        return page;

    }

}