package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CALockRegisterMapper;
import com.ejianc.business.oa.bean.CALockRegisterEntity;
import com.ejianc.business.oa.service.ICALockRegisterService;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * CA锁登记主实体
 * 
 * @author generator
 * 
 */
@Service("cALockRegisterService")
public class CALockRegisterServiceImpl extends BaseServiceImpl<CALockRegisterMapper, CALockRegisterEntity> implements ICALockRegisterService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;

    /**
     * 发消息--CA锁到期提醒
     * 每天早上8点查询所有生效的CA锁登记单据，当前日期=提醒日期的，给负责人、经办人发送系统消息
     */
    @Override
    public String sendCAMsgToPerson() {
        logger.info("开始定时任务：----");
        //1、获取已生效、已到提醒日期的CA锁单据
        LambdaQueryWrapper<CALockRegisterEntity> lambda2 = new LambdaQueryWrapper<CALockRegisterEntity>();
        lambda2.in(CALockRegisterEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String nowStr = formatter.format(new Date());
        lambda2.eq(CALockRegisterEntity::getRemindDate, nowStr + " 00:00:00");
        List<CALockRegisterEntity> caLockRegisterEntityList = super.list(lambda2);
        String msg = "";
        if (CollectionUtils.isNotEmpty(caLockRegisterEntityList)){
            for (CALockRegisterEntity caLockRegisterEntity : caLockRegisterEntityList) {
                msg = this.sendMsg(caLockRegisterEntity, "CA锁单据办理延期", "您好，今天是“" + caLockRegisterEntity.getCaLockName() + "”办理延期的提醒日，请尽快办理延期，如已办理请忽略");
                if (StringUtils.isNotBlank(msg)){
                    logger.error("CA锁到期提醒发送信息异常：" + msg);
                }
            }
        }
        logger.info("定时任务结束！");
        return msg;
    }

    private String sendMsg(CALockRegisterEntity caLockRegisterEntity, String subject, String content) {
        String[] msgRecUserIds = new String[]{};
        if (caLockRegisterEntity.getHeadId() == caLockRegisterEntity.getEmployeeId()){
            msgRecUserIds = new String[]{caLockRegisterEntity.getEmployeeId().toString()};
        }else {
            msgRecUserIds = new String[]{caLockRegisterEntity.getHeadId().toString(), caLockRegisterEntity.getEmployeeId().toString()};
        }
        logger.info("消息接收人: {}", StringUtils.join(msgRecUserIds, ","));
        for (String msgRecUserId : msgRecUserIds) {
            PushMsgParameter msgParameter = new PushMsgParameter();
            //消息接收人
            msgParameter.setReceivers(new String[]{msgRecUserId});

            String userName = msgRecUserId.equals(caLockRegisterEntity.getEmployeeId().toString()) ? caLockRegisterEntity.getEmployeeName() : caLockRegisterEntity.getHeadName();
            //消息内容
            msgParameter.setContent(userName + content);


            //消息主题
            msgParameter.setSubject(subject);
            //消息类型
            msgParameter.setMsgType("notice");
            msgParameter.setTenantId(caLockRegisterEntity.getTenantId().toString());
            //消息保存
            msgParameter.setSaveFlag(true);
            //地址
            msgParameter.setPcUrl("/ejc-oa-frontend/#/caLockRegister/card?id=" + caLockRegisterEntity.getId());
            //消息发送人
            msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
            //消息发送渠道
            msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});
            logger.info("发送消息信息: {}", JSONObject.toJSONString(msgParameter));
            CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
            if (!msgSendResp.isSuccess()) {
                return msgSendResp.getMsg();
            }
        }

        return null;
    }
}
