package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.consts.EducationCodeEnum;
import com.ejianc.business.oa.controller.SqlParam;
import com.ejianc.business.oa.mapper.ManagementMapper;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 证件管理档案
 * 
 * @author generator
 * 
 */
@Service("managementService")
public class ManagementServiceImpl extends BaseServiceImpl<ManagementMapper, ManagementEntity> implements IManagementService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String TEMPLATE_KEY_PREFIX = "template_data_cache_market_project";
    private final String TEMPLATE_KEY_SEPRATOR = ":";
    private final int TIMEOUT = 1800;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ICertRecordService certRecordService;
    @Autowired
    private ManagementMapper managementMapper;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<ManagementVO> saveOrUpdate(ManagementVO saveorUpdateVO) {
        //证件编号租户内不能重复
        LambdaQueryWrapper<ManagementEntity> lambda = Wrappers.<ManagementEntity>lambdaQuery();
        lambda.eq(ManagementEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ManagementEntity::getCertCode,saveorUpdateVO.getCertCode());
        if(null!=saveorUpdateVO.getId()){
            lambda.ne(ManagementEntity::getId,saveorUpdateVO.getId());
        }
        List<ManagementEntity> list = super.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            return CommonResponse.error("证件编号已存在!");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int num = 90;
        try {
            if(1==saveorUpdateVO.getIsTerm()){
                saveorUpdateVO.setTermStatus(0);
            }else{
                Date failureDate = sdf.parse(sdf.format(saveorUpdateVO.getFailureDate()));
                Date now = sdf.parse(sdf.format(new Date()));
                long nd = 1000 * 24 * 60 * 60;
                long diff = failureDate.getTime() - now.getTime();
                long day = diff / nd;
                if(day>num){
                    saveorUpdateVO.setTermStatus(0);
                }else if(day<=num&&day>=0){
                    saveorUpdateVO.setTermStatus(1);
                }else if(day<0){
                    saveorUpdateVO.setTermStatus(2);
                }
            }
        } catch (Exception e) {
        }
        ManagementEntity entity = BeanMapper.map(saveorUpdateVO, ManagementEntity.class);
        super.saveOrUpdate(entity, false);
        ManagementVO vo = BeanMapper.map(entity, ManagementVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> saveOrUpdateBatch(List<ManagementVO> listVo) {
        if(CollectionUtils.isNotEmpty(listVo)){
            listVo.forEach(saveorUpdateVO->{
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                int num = 90;
                try {
                    if(1==saveorUpdateVO.getIsTerm()){
                        saveorUpdateVO.setTermStatus(0);
                    }else{
                        Date failureDate = sdf.parse(sdf.format(saveorUpdateVO.getFailureDate()));
                        Date now = sdf.parse(sdf.format(new Date()));
                        long nd = 1000 * 24 * 60 * 60;
                        long diff = failureDate.getTime() - now.getTime();
                        long day = diff / nd;
                        if(day>num){
                            saveorUpdateVO.setTermStatus(0);
                        }else if(day<=num&&day>=0){
                            saveorUpdateVO.setTermStatus(1);
                        }else if(day<0){
                            saveorUpdateVO.setTermStatus(2);
                        }
                    }
                } catch (Exception e) {
                }
            });
            List<ManagementEntity> listEntity = BeanMapper.mapList(listVo, ManagementEntity.class);
            super.saveOrUpdateBatch(listEntity);
        }
        return CommonResponse.success("数据导入保存成功！");
    }

    @Override
    public CommonResponse<String> deleteBatch(List<ManagementVO> vos) {
        super.removeByIds(vos.stream().map(ManagementVO::getId).collect(Collectors.toList()),true);
        certRecordService.deleteByFk(vos.stream().map(ManagementVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        JSONObject respData = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ManagementVO> saveList = new ArrayList<>();
        List<JSONObject> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            logger.info("接收到项目导入文件：[{}]", originalFileName);
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            logger.info("项目导入文件行数(包含非数据行)：[{}]", result.size());
            logger.info("项目导入文件内容：[{}]", JSONObject.toJSONString(result));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
                List<String> rowData = null;
                List<ManagementEntity> dbList = null;
                List<String> saveNameList = new ArrayList<>();
                List<String> saveCodeList = new ArrayList<>();
                ManagementVO proInfo = null;

                //每次仅处理前100条数据
                for(int i=1; (i<result.size() && i < 100); i++) {
                    proInfo = new ManagementVO();
                    //从第二行开始读取数据
                    rowData = result.get(i);
                    JSONObject errInfo = null;
                    try {
                        errInfo = rowDataCheck(i, rowData, saveNameList, saveCodeList, proInfo);
                    }catch (Exception e){
                        return CommonResponse.error("文件内容格式不合法");
                    }
                    logger.info("第{}行校验结果：{}", i+1, null != errInfo ? errInfo.get("errMsg") : "校验通过！");
                    if(null != errInfo) {
                        proInfo = null;
                        errorList.add(errInfo);
                        continue;
                    }
                    proInfo.setStockStatus(0);//在册
                    proInfo.setTermStatus(0);//正常
                    proInfo.setType(0);//个人
                    proInfo.setOrgId(sessionManager.getUserContext().getOrgId());
                    proInfo.setOrgName(sessionManager.getUserContext().getOrgName());
                    saveList.add(proInfo);
                }

                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(saveList)) {
                    String key = getCacheKey();
                    respData.put("templateKey", key);
                    cacheManager.setex(key, JSONObject.toJSONString(saveList), TIMEOUT);
                }
            }
            respData.put("successList", saveList);
            respData.put("importableNum", saveList.size());
            respData.put("errorList", errorList);
            respData.put("errorNum", errorList);
            return CommonResponse.success(respData);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImportOrg(HttpServletRequest request, HttpServletResponse response) {
        JSONObject respData = new JSONObject();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ManagementVO> saveList = new ArrayList<>();
        List<JSONObject> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            logger.info("接收到项目导入文件：[{}]", originalFileName);
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            logger.info("项目导入文件行数(包含非数据行)：[{}]", result.size());
            logger.info("项目导入文件内容：[{}]", JSONObject.toJSONString(result));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(result)) {
                List<String> rowData = null;
                List<ManagementEntity> dbList = null;
                List<String> saveNameList = new ArrayList<>();
                List<String> saveCodeList = new ArrayList<>();
                ManagementVO proInfo = null;

                //每次仅处理前100条数据
                for(int i=1; (i<result.size() && i < 100); i++) {
                    proInfo = new ManagementVO();
                    //从第二行开始读取数据
                    rowData = result.get(i);
                    JSONObject errInfo = null;
                    try {
                        errInfo = rowDataCheckOrg(i, rowData, saveNameList, saveCodeList, proInfo);
                    }catch (Exception e){
                        return CommonResponse.error("文件内容格式不合法");
                    }

                    logger.info("第{}行校验结果：{}", i+1, null != errInfo ? errInfo.get("errMsg") : "校验通过！");
                    if(null != errInfo) {
                        proInfo = null;
                        errorList.add(errInfo);
                        continue;
                    }
                    proInfo.setStockStatus(0);//在册
                    proInfo.setTermStatus(0);//正常
                    proInfo.setType(1);//企业
                    proInfo.setOrgId(sessionManager.getUserContext().getOrgId());
                    proInfo.setOrgName(sessionManager.getUserContext().getOrgName());

                    saveList.add(proInfo);
                }

                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(saveList)) {
                    String key = getCacheKey();
                    respData.put("templateKey", key);
                    cacheManager.setex(key, JSONObject.toJSONString(saveList), TIMEOUT);
                }
            }
            respData.put("successList", saveList);
            respData.put("importableNum", saveList.size());
            respData.put("errorList", errorList);
            respData.put("errorNum", errorList);
            return CommonResponse.success(respData);
        }
    }


    private String getCacheKey() {
        return TEMPLATE_KEY_PREFIX + TEMPLATE_KEY_SEPRATOR +
                InvocationInfoProxy.getUserid() + TEMPLATE_KEY_SEPRATOR +
                System.currentTimeMillis();
    }

    private JSONObject generateErrorRow(int rowNum, List<String> rowData, String msg) {
        JSONObject error = new JSONObject();
        error.put("rowNum", rowNum);
        error.put("certCode", rowData.get(9));
        error.put("certName", rowData.get(8));
        error.put("effectiveDate", rowData.get(10));
        error.put("errMsg", msg);
        return error;
    }

    private JSONObject generateErrorRowOrg(int rowNum, List<String> rowData, String msg) {
        JSONObject error = new JSONObject();
        error.put("rowNum", rowNum);
        error.put("certCode", rowData.get(2));
        error.put("certName", rowData.get(1));
        error.put("effectiveDate", rowData.get(3));
        error.put("errMsg", msg);
        return error;
    }

    private JSONObject rowDataCheck(int rowNum, List<String> rowData, List<String> curVlidProNameList, List<String> curVlidProCodeList, ManagementVO proInfo) throws Exception{
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String personalType = rowData.get(0);
        String name = rowData.get(1);
        String telephone = rowData.get(2);
        String sex = rowData.get(3);
        String idNumber = rowData.get(4);
        String educationName = rowData.get(5);
        String major = rowData.get(6);
        String certTypeName = rowData.get(7);
        String certName = rowData.get(8);
        String certCode = rowData.get(9);
        String effectiveDate = rowData.get(10);
        String failureDate = rowData.get(11);
        String certStatus = rowData.get(12);
        String office = rowData.get(13);
        String storageLocation = rowData.get(14);
        String memo = rowData.get(15);

        Long tenantId = InvocationInfoProxy.getTenantid();

        if (StringUtils.isBlank(personalType)) {
            return generateErrorRow(rowNum, rowData, "人员类别为空");
        } else {
            // 默认导入全部为外部人员，若为内部，这里需要关联userId
           /* if ("内部人员".equals(personalType)) {
                proInfo.setPersonalType(0);
            } else {*/
            proInfo.setPersonalType(1);
            //}
        }
        if(StringUtils.isBlank(name)) {
            return generateErrorRow(rowNum, rowData, "姓名为空");
        }else{
            proInfo.setName(name);
        }

        if(StringUtils.isBlank(telephone)) {
            return generateErrorRow(rowNum, rowData, "联系电话为空");
        }else{
            BigDecimal bd = new BigDecimal(telephone);
            proInfo.setTelephone(bd.toPlainString());
        }

        if(StringUtils.isBlank(sex)) {
            return generateErrorRow(rowNum, rowData, "性别为空");
        }else{
            if("女".equals(sex)){
                proInfo.setSex(1);
            }else{
                proInfo.setSex(0);
            }
        }
        proInfo.setIdNumber(idNumber);
        // 学历处理
        proInfo.setEducationCode(EducationCodeEnum.getCodeByName(educationName));

        proInfo.setMajor(major);
        proInfo.setOffice(office);
        proInfo.setStorageLocation(storageLocation);
        proInfo.setMemo(memo);

        if (StringUtils.isBlank(certTypeName)) {
            return generateErrorRow(rowNum, rowData, "证件类别为空");
        } else {
            CommonResponse<DefdocDetailVO> docres = defdocApi.getDefDocByName(403601896173207615L, certTypeName);
            if (docres.isSuccess() && null != docres.getData()) {
                proInfo.setCertTypeId(docres.getData().getId());
                proInfo.setCertTypeName(docres.getData().getName());
            } else {
                return generateErrorRow(rowNum, rowData, "档案中无该证照类别(个人)项");
            }
        }
        if(StringUtils.isBlank(failureDate)) {
            proInfo.setIsTerm(1);
        }else{
            proInfo.setIsTerm(0);
        }

        if(StringUtils.isBlank(certName)) {
            return generateErrorRow(rowNum, rowData, "证件名称为空");
        }
        proInfo.setCertName(certName);
        if(StringUtils.isBlank(certCode)) {
            return generateErrorRow(rowNum, rowData, "证件编号为空");
        }
        if(StringUtils.isBlank(effectiveDate)) {
            return generateErrorRow(rowNum, rowData, "生效时间为空");
        }else{
            try {
                if(effectiveDate.contains("-")){
                    proInfo.setEffectiveDate(simpleDateFormat.parse(effectiveDate));
                }else{
                    String date = getDate(Integer.parseInt(effectiveDate));
                    proInfo.setEffectiveDate(simpleDateFormat.parse(date));
                }
            }catch (Exception e){
                return generateErrorRow(rowNum, rowData, "生效时间转换错误");
            }
        }
        if(StringUtils.isNotBlank(failureDate)){
            try {
                if(failureDate.contains("-")){
                    proInfo.setFailureDate(simpleDateFormat.parse(failureDate));
                }else{
                    String date = getDate(Integer.parseInt(failureDate));
                    proInfo.setFailureDate(simpleDateFormat.parse(date));
                }
            }catch (Exception e){
                return generateErrorRow(rowNum, rowData, "失效时间转换错误");
            }
        }
        if(StringUtils.isBlank(certStatus)) {
            return generateErrorRow(rowNum, rowData, "证书使用状态为空");
        }else{
            CommonResponse<DefdocDetailVO> docres = defdocApi.getDefDocByName(403601428684472320L,certStatus);
            if(docres.isSuccess()&&null!=docres.getData()){
                proInfo.setCertStatus(docres.getData().getId());
            }else{
                return generateErrorRow(rowNum, rowData, "档案中无该证书使用状态项");
            }
        }
        //编码唯一校验
        boolean codeCheck = curVlidProCodeList.contains(certCode);
        if(!codeCheck && StringUtils.isNotBlank(certCode)) {
            proInfo.setTenantId(tenantId);
            proInfo.setCertCode(certCode);
            LambdaQueryWrapper<ManagementEntity> lambda = Wrappers.<ManagementEntity>lambdaQuery();
            lambda.eq(ManagementEntity::getTenantId,InvocationInfoProxy.getTenantid());
            lambda.eq(ManagementEntity::getCertCode,certCode);
            List<ManagementEntity> list = super.list(lambda);
            if(CollectionUtils.isNotEmpty(list)){
                codeCheck = true;
            }else{
                curVlidProCodeList.add(certCode);
                codeCheck = false;
            }
        }
        if(codeCheck) {
            return generateErrorRow(rowNum, rowData, "编码重复");
        }
        return null;
    }

    public String getDate(int days) {
        Calendar c = Calendar.getInstance();
        c.set(1900, 0, 1);
        c.add(Calendar.DATE, days - 2);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(c.getTime());
        return dateString;
    }

    private JSONObject rowDataCheckOrg(int rowNum, List<String> rowData, List<String> curVlidProNameList, List<String> curVlidProCodeList, ManagementVO proInfo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String certTypeName = rowData.get(0);
        String certName = rowData.get(1);
        String certCode = rowData.get(2);
        String effectiveDate = rowData.get(3);
        String failureDate = rowData.get(4);
        String certStatus = rowData.get(5);
        String office = rowData.get(6);
        String storageLocation = rowData.get(7);
        String memo = rowData.get(8);

        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isBlank(certTypeName)) {
            return generateErrorRowOrg(rowNum, rowData, "证件类别为空");
        } else {
            CommonResponse<DefdocDetailVO> docres = defdocApi.getDefDocByName(403602819113025550L, certTypeName);
            if (docres.isSuccess() && null != docres.getData()) {
                proInfo.setCertTypeId(docres.getData().getId());
                proInfo.setCertTypeName(docres.getData().getName());
            } else {
                return generateErrorRowOrg(rowNum, rowData, "档案中无该证照类别(企业)项");
            }
        }
        if(StringUtils.isBlank(failureDate)) {
            proInfo.setIsTerm(1);
        }else{
            proInfo.setIsTerm(0);
        }
        if(StringUtils.isBlank(certName)) {
            return generateErrorRowOrg(rowNum, rowData, "证件名称为空");
        }
        proInfo.setCertName(certName);
        if(StringUtils.isBlank(certCode)) {
            return generateErrorRowOrg(rowNum, rowData, "证件编号为空");
        }
        if(StringUtils.isBlank(effectiveDate)) {
            return generateErrorRowOrg(rowNum, rowData, "生效时间为空");
        }else{
            try {
                proInfo.setEffectiveDate(simpleDateFormat.parse(effectiveDate));
            }catch (Exception e){
                return generateErrorRowOrg(rowNum, rowData, "生效时间转换错误");
            }
        }
        if(StringUtils.isNotBlank(failureDate)){
            try {
                proInfo.setFailureDate(simpleDateFormat.parse(failureDate));
            }catch (Exception e){
                return generateErrorRowOrg(rowNum, rowData, "失效时间转换错误");
            }
        }
        if(StringUtils.isBlank(certStatus)) {
            return generateErrorRowOrg(rowNum, rowData, "证书使用状态为空");
        }else{
            CommonResponse<DefdocDetailVO> docres = defdocApi.getDefDocByName(403601428684472320L,certStatus);
            if(docres.isSuccess()&&null!=docres.getData()){
                proInfo.setCertStatus(docres.getData().getId());
            }else{
                return generateErrorRowOrg(rowNum, rowData, "档案中无该证书使用状态项");
            }
        }
        //编码唯一校验
        boolean codeCheck = curVlidProCodeList.contains(certCode);
        if(!codeCheck && StringUtils.isNotBlank(certCode)) {
            proInfo.setTenantId(tenantId);
            proInfo.setCertCode(certCode);
            LambdaQueryWrapper<ManagementEntity> lambda = Wrappers.<ManagementEntity>lambdaQuery();
            lambda.eq(ManagementEntity::getTenantId,InvocationInfoProxy.getTenantid());
            lambda.eq(ManagementEntity::getCertCode,certCode);
            List<ManagementEntity> list = super.list(lambda);
            if(CollectionUtils.isNotEmpty(list)){
                codeCheck = true;
            }else{
                curVlidProCodeList.add(certCode);
                codeCheck = false;
            }
        }
        if(codeCheck) {
            return generateErrorRowOrg(rowNum, rowData, "编码重复");
        }
        proInfo.setOffice(office);
        proInfo.setStorageLocation(storageLocation);
        proInfo.setMemo(memo);
        return null;
    }
    @Override
    public List<Map<String, Object>> queryCertExpireWarn(List<SqlParam> sqlParamList) {
        return managementMapper.queryCertExpireWarn(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryCertDeferWarn(List<SqlParam> sqlParamList) {
        return managementMapper.queryCertDeferWarn(sqlParamList);
    }

    @Override
    public List<ManagementVO> excelExports(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("certMajor");

        /** 租户隔离 */
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = param.getParams().get("certTypeId");
                Object certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue(certTypeIdOrg + "," + certTypeId);
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }

        IPage<ManagementEntity> page = this.queryPage(param,false);
        List<ManagementVO> list = new ArrayList<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(page.getRecords())){
            Map<Long,String> mapCertStatusRes = new HashMap<>();
            CommonResponse<List<DefdocDetailVO>> certStatusRes = defdocApi.getDefDocByDefId(403601428684472320L);
            Map<Long,String> mapCertTypeIdRes = new HashMap<>();
            CommonResponse<List<DefdocDetailVO>> certTypeIdRes = defdocApi.getDefDocByDefId(403601896173207615L);
            Map<Long,String> mapCertTypeIdOrgRes = new HashMap<>();
            CommonResponse<List<DefdocDetailVO>> certTypeIdOrgRes = defdocApi.getDefDocByDefId(403602819113025550L);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(certStatusRes.getData())) {
                mapCertStatusRes = certStatusRes.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(certTypeIdRes.getData())) {
                mapCertTypeIdRes = certTypeIdRes.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(certTypeIdOrgRes.getData())) {
                mapCertTypeIdOrgRes = certTypeIdOrgRes.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getName));
            }
            list = BeanMapper.mapList(page.getRecords(), ManagementVO.class);
            for(ManagementVO vo : list){
                if(0==vo.getType()){
                    vo.setTypeName("个人");
                    vo.setCertTypeName(mapCertTypeIdRes.get(vo.getCertTypeId()));
                }else{
                    vo.setTypeName("企业");
                    vo.setCertTypeName(mapCertTypeIdOrgRes.get(vo.getCertTypeId()));
                }
                if(0==vo.getStockStatus()){
                    vo.setStockStatusName("在册");
                }else{
                    vo.setStockStatusName("借出");
                }
                vo.setCertStatusName(mapCertStatusRes.get(vo.getCertStatus()));
            }
        }
        return list;
    }
}
