package com.ejianc.business.snapshort.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.snapshort.bean.SnapshotMarkEntity;
import com.ejianc.business.snapshort.service.ISnapshotMarkService;
import com.ejianc.business.snapshort.vo.SnapshotMarkVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 随手拍-标签实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("snapshotMark")
public class SnapshotMarkController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISnapshotMarkService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SnapshotMarkVO> saveOrUpdate(@RequestBody SnapshotMarkVO saveOrUpdateVO) {
    	SnapshotMarkEntity entity = BeanMapper.map(saveOrUpdateVO, SnapshotMarkEntity.class);
        LambdaQueryWrapper<SnapshotMarkEntity> lambda = Wrappers.<SnapshotMarkEntity>lambdaQuery();
        lambda.eq(SnapshotMarkEntity::getCode, saveOrUpdateVO.getCode());
        lambda.ne(saveOrUpdateVO.getId() != null,SnapshotMarkEntity::getId, saveOrUpdateVO.getId());
        List<SnapshotMarkEntity> list = service.list(lambda);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("标签名称已存在!");
        }
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
////                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//
//        }
//        entity.setEnabled(1);
    	service.saveOrUpdate(entity, false);
    	SnapshotMarkVO vo = BeanMapper.map(entity, SnapshotMarkVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SnapshotMarkVO> updateStatus(@RequestBody SnapshotMarkVO saveOrUpdateVO) {
    	SnapshotMarkEntity entity = BeanMapper.map(saveOrUpdateVO, SnapshotMarkEntity.class);
    	service.saveOrUpdate(entity, false);
    	SnapshotMarkVO vo = BeanMapper.map(entity, SnapshotMarkVO.class);
    	return CommonResponse.success("启用/停用成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SnapshotMarkVO> queryDetail(Long id) {
    	SnapshotMarkEntity entity = service.selectById(id);
    	SnapshotMarkVO vo = BeanMapper.map(entity, SnapshotMarkVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SnapshotMarkVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SnapshotMarkVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SnapshotMarkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SnapshotMarkVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        fuzzyFields.add("description");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<SnapshotMarkEntity> page = service.queryPage(param,false);
        IPage<SnapshotMarkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SnapshotMarkVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SnapshotMarkVO>> queryAll() {
        LambdaQueryWrapper<SnapshotMarkEntity> lambda = Wrappers.<SnapshotMarkEntity>lambdaQuery();
        lambda.eq(SnapshotMarkEntity::getEnabled, 1);
        lambda.orderByDesc(SnapshotMarkEntity::getCreateTime);
        List<SnapshotMarkEntity> list = service.list(lambda);
        List<SnapshotMarkVO> snapshotMarkVOS = BeanMapper.mapList(list, SnapshotMarkVO.class);
        return CommonResponse.success("查询列表数据成功！",snapshotMarkVOS);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SnapshotMarkEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SnapshotMark-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSnapshotMarkData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SnapshotMarkVO>> refSnapshotMarkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getLong("projectId")));
            }
        }
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        IPage<SnapshotMarkEntity> page = service.queryPage(param,false);
        IPage<SnapshotMarkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SnapshotMarkVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
