package com.ejianc.business.oa.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.oa.vo.BidProjectVO;
import com.ejianc.business.oa.vo.BidRequireVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标文件评审实体
 *
 * @author generator
 *
 */
 @TableName("oa_bid")
public class BidEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private  String billCode; // 单据编号
    @TableField(value="opportunity_id")
    private  Long opportunityId; // 工程主键
    @TableField(value="opportunity_name")
    private  String opportunityName; // 工程名称
    @TableField(value="engineering_type")
    private  Long engineeringType; // 工程类型
    @TableField(value="engineering_type_name")
    private  String engineeringTypeName; // 工程类型名称
    @TableField(value="employee_id")
    private  Long employeeId; // 项目经理主键
    @TableField(value="employee_name")
    private  String employeeName; // 项目经理
    @TableField(value="offer_mny")
    private java.math.BigDecimal offerMny; // 报价
    @TableField(value="bond_mny")
    private java.math.BigDecimal bondMny; // 投标保证金
    @TableField(value="bid_date")
    private java.util.Date bidDate; // 开标日期
    @TableField(value="bid_mny")
    private java.math.BigDecimal bidMny; // 投标金额
    @TableField(value="content")
    private  String content; // 投标内容
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="file_urls")
    private  String fileUrls; // 投标文件
    @TableField(value="org_id")
    private  Long orgId; // 所属组织
    @TableField(value="org_name")
    private  String orgName; // 组织名称
    @TableField(value="maker_id")
    private  Long makerId; // 编制人主键
    @TableField(value="maker_name")
    private  String makerName; // 编制人名称
    @TableField(value="make_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date makeDate;//编制日期
    @TableField(value="tech_manage")
    private  Long techManage; // 技术负责人
    @TableField(value="tech_manage_name")
    private  String techManageName; // 技术负责人
    @TableField(value="highest_mny")
    private BigDecimal highestMny; // 最高限价


    @TableField(exist=false)
    @SubEntity(serviceName="bidDetailService", pidName = "bidId")
    private List<BidDetailEntity> detailList = new ArrayList<>(); // 投标文件评审子实体
    @SubEntity(serviceName="bidProjectService")
    @TableField(exist=false)
    private List<BidProjectEntity> projectVOList = new ArrayList<>(); // 项目业绩选择
    @SubEntity(serviceName="bidRequireService")
    @TableField(exist=false)
    private List<BidRequireEntity> requireVOList = new ArrayList<>(); // 招标文件要求

    /**
     * 单据编号
     */
    public  String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode( String billCode) {
        this.billCode = billCode;
    }
    /**
     * 工程主键
     */
    public  Long getOpportunityId() {
        return opportunityId;
    }

    public Long getTechManage() {
        return techManage;
    }

    public void setTechManage(Long techManage) {
        this.techManage = techManage;
    }

    public String getTechManageName() {
        return techManageName;
    }

    public void setTechManageName(String techManageName) {
        this.techManageName = techManageName;
    }

    public List<BidProjectEntity> getProjectVOList() {
        return projectVOList;
    }

    public void setProjectVOList(List<BidProjectEntity> projectVOList) {
        this.projectVOList = projectVOList;
    }

    public List<BidRequireEntity> getRequireVOList() {
        return requireVOList;
    }

    public void setRequireVOList(List<BidRequireEntity> requireVOList) {
        this.requireVOList = requireVOList;
    }

    /**
     * 工程主键
     */
    public void setOpportunityId( Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    /**
     * 工程名称
     */
    public  String getOpportunityName() {
        return opportunityName;
    }

    /**
     * 工程名称O
     */
    public void setOpportunityName( String opportunityName) {
        this.opportunityName = opportunityName;
    }
    /**
     * 工程类型
     */
    public  Long getEngineeringType() {
        return engineeringType;
    }

    /**
     * 工程类型
     */
    public void setEngineeringType( Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    /**
     * 工程类型名称
     */
    public  String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    /**
     * 工程类型名称
     */
    public void setEngineeringTypeName( String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    /**
     * 项目经理主键
     */
    public  Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 项目经理主键
     */
    public void setEmployeeId( Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 项目经理
     */
    public  String getEmployeeName() {
        return employeeName;
    }

    /**
     * 项目经理
     */
    public void setEmployeeName( String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 报价
     */
    public java.math.BigDecimal getOfferMny() {
        return offerMny;
    }

    /**
     * 报价
     */
    public void setOfferMny(java.math.BigDecimal offerMny) {
        this.offerMny = offerMny;
    }
    /**
     * 投标保证金
     */
    public java.math.BigDecimal getBondMny() {
        return bondMny;
    }

    /**
     * 投标保证金
     */
    public void setBondMny(java.math.BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    /**
     * 开标日期
     */
    public java.util.Date getBidDate() {
        return bidDate;
    }

    /**
     * 开标日期
     */
    public void setBidDate(java.util.Date bidDate) {
        this.bidDate = bidDate;
    }
    /**
     * 投标金额
     */
    public java.math.BigDecimal getBidMny() {
        return bidMny;
    }

    /**
     * 投标金额
     */
    public void setBidMny(java.math.BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    /**
     * 投标内容
     */
    public  String getContent() {
        return content;
    }

    /**
     * 投标内容
     */
    public void setContent( String content) {
        this.content = content;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 投标文件
     */
    public  String getFileUrls() {
        return fileUrls;
    }

    /**
     * 投标文件
     */
    public void setFileUrls( String fileUrls) {
        this.fileUrls = fileUrls;
    }
    /**
     * 所属组织
     */
    public  Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId( Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public  String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName( String orgName) {
        this.orgName = orgName;
    }
    /**
     * 编制人主键
     */
    public  Long getMakerId() {
        return makerId;
    }

    /**
     * 编制人主键
     */
    public void setMakerId( Long makerId) {
        this.makerId = makerId;
    }
    /**
     * 编制人名称
     */
    public  String getMakerName() {
        return makerName;
    }

    /**
     * 编制人名称
     */
    public void setMakerName( String makerName) {
        this.makerName = makerName;
    }

    public Date getMakeDate() {
        return makeDate;
    }

    public void setMakeDate(Date makeDate) {
        this.makeDate = makeDate;
    }

    public BigDecimal getHighestMny() {
        return highestMny;
    }

    public void setHighestMny(BigDecimal highestMny) {
        this.highestMny = highestMny;
    }

    public List<BidDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BidDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
