/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.InviteEntity;
import com.ejianc.business.oa.bean.InvitePersonEntity;
import com.ejianc.business.oa.service.IInvitePersonService;
import com.ejianc.business.oa.service.IInviteService;
import com.ejianc.business.oa.vo.InvitePersonExportVO;
import com.ejianc.business.oa.vo.InviteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invite"})
public class InviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OA_INVITE = "OA_INVITE";
    @Autowired
    private IInviteService inviteService;
    @Autowired
    private IInvitePersonService iInvitePersonService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveorUpdateVO) {
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(OA_INVITE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                saveorUpdateVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        InviteEntity entity = (InviteEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), InviteEntity.class));
        this.inviteService.saveOrUpdate((Object)entity, false);
        InviteVO vo = (InviteVO)((Object)BeanMapper.map((Object)((Object)entity), InviteVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
        InviteEntity entity = (InviteEntity)((Object)this.inviteService.selectById(id));
        InviteVO vo = (InviteVO)((Object)BeanMapper.map((Object)((Object)entity), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        this.inviteService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("makerName");
        fuzzyFields.add("bidMethod");
        fuzzyFields.add("tederType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.inviteService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryHighestMnyByProj"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteEntity> queryHighestMnyByProj(Long opportunityId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(InviteEntity::getOpportunityId, (Object)opportunityId);
        queryWrapper.in(InviteEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        queryWrapper.last("limit 1");
        InviteEntity InviteEntity2 = (InviteEntity)((Object)this.inviteService.getOne((Wrapper)queryWrapper, false));
        if (ObjectUtil.isNotEmpty((Object)((Object)InviteEntity2))) {
            LambdaQueryWrapper personQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(InvitePersonEntity::getInviteId, (Object)InviteEntity2.getId())).eq(BaseEntity::getDr, (Object)0);
            List list = this.iInvitePersonService.list((Wrapper)personQueryWrapper);
            InviteEntity2.setPersonList(list);
        }
        return CommonResponse.success((String)"\u6839\u636e\u9879\u76ee\u67e5\u8be2\u6700\u9ad8\u9650\u4ef7\u6210\u529f\uff01", (Object)((Object)InviteEntity2));
    }

    @RequestMapping(value={"/excelExportPerson"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportPerson(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("makerName");
        fuzzyFields.add("bidMethod");
        fuzzyFields.add("tederType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<InvitePersonExportVO> list = this.inviteService.queryPersonList(param);
        for (InvitePersonExportVO invitePersonExportVO : list) {
            String projectStage = invitePersonExportVO.getProjectStage();
            if (!StringUtils.isNotBlank((CharSequence)projectStage)) continue;
            invitePersonExportVO.setProjectStageName("1".equals(projectStage) ? "\u5df2\u62a5\u540d" : "\u5df2\u8bc4\u5ba1");
        }
        HashMap<String, List<InvitePersonExportVO>> beans = new HashMap<String, List<InvitePersonExportVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Invite-person-export.xlsx", beans, response);
    }
}

