package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 证件管理档案
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("management")
public class ManagementController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IManagementService service;

    @Autowired
    private IDefdocApi defdocApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ManagementVO> saveOrUpdate(@RequestBody ManagementVO saveorUpdateVO) {
    	return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<ManagementVO> listVo) {
        return service.saveOrUpdateBatch(listVo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ManagementVO> queryDetail(Long id) {
    	ManagementEntity entity = service.selectById(id);
    	ManagementVO vo = BeanMapper.map(entity, ManagementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ManagementVO> vos) {
        return service.deleteBatch(vos);
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("certMajor");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = param.getParams().get("certTypeId");
                Object certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue(certTypeIdOrg + "," + certTypeId);
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }

        IPage<ManagementEntity> page = service.queryPage(param,false);
        IPage<ManagementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ManagementVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            list = BeanMapper.mapList(page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if(1==vo.getIsTerm()){
                    vo.setFailureDateName("长期有效");
                }else{
                    vo.setFailureDateName(DateFormater.getInstance(vo.getFailureDate()).format(DateFormater.SHORT_FORMAT));
                }
            });
        }
  		pageData.setRecords(list);
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnExpireList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> queryUnExpireList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        List<Integer> termStatusList = new ArrayList<>();
        termStatusList.add(1);
        termStatusList.add(2);
        Parameter termStatus = param.getParams().get("termStatus");
        if(null==termStatus){
            param.getParams().put("termStatus", new Parameter(QueryParam.IN, termStatusList));
        }
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = param.getParams().get("certTypeId");
                Object certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue(certTypeIdOrg + "," + certTypeId);
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }

        IPage<ManagementEntity> page = service.queryPage(param,false);
        IPage<ManagementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ManagementVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            list = BeanMapper.mapList(page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if(1==vo.getIsTerm()){
                    vo.setFailureDateName("长期有效");
                }else{
                    vo.setFailureDateName(DateFormater.getInstance(vo.getFailureDate()).format(DateFormater.SHORT_FORMAT));
                }
                if(2==vo.getTermStatus()){
                    vo.setExprieName("已过期");
                    vo.setExprieDay(0L);
                }else{
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date failureDate = sdf.parse(sdf.format(vo.getFailureDate()));
                        Date now = sdf.parse(sdf.format(new Date()));
                        long nd = 1000 * 24 * 60 * 60;
                        long diff = failureDate.getTime() - now.getTime();
                        long day = diff / nd;
                        vo.setExprieDay(day);
                        vo.setExprieName("还有" + day + "天到期");
                    } catch (Exception e) {
                        logger.error("信息异常：", e);
                    }
                }
            });
        }
        pageData.setRecords(list);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 设置参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "managementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ManagementVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText,
            @RequestParam(required=false) String searchObject) {

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("termStatus", new Parameter(QueryParam.NE, 2));
        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            for(String key : search.keySet()){
                queryParam.getParams().put(key,new Parameter(QueryParam.LIKE,search.get(key).toString()));
            }
        }
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("certName");
        queryParam.getFuzzyFields().add("certCode");
        queryParam.getFuzzyFields().add("name");
        queryParam.getOrderMap().put("createTime","desc");
        IPage<ManagementEntity> page = service.queryPage(queryParam,false);
        IPage<ManagementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ManagementVO> list = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            list = BeanMapper.mapList(page.getRecords(), ManagementVO.class);
            list.forEach(vo -> {
                if(0==vo.getType()){
                    vo.setTypeName("个人");
                }else{
                    vo.setTypeName("企业");
                }
                if(0==vo.getStockStatus()){
                    vo.setStockStatusName("在册");
                }else{
                    vo.setStockStatusName("借出");
                }
            });
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @RequestMapping(value = "/excelExports", method = RequestMethod.POST)
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ManagementVO> list = service.excelExports(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("managementExportPerson.xlsx", beans, response);
    }


    /**
     * @Description closeOrder 定时检查到期证照
     */
    @RequestMapping(value = "/UnExpire", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse UnExpire(HttpServletRequest request) {
        logger.info("开始定时任务：----");
        int num = 90;
        if(num>0){
            LambdaQueryWrapper<ManagementEntity> lambdachange = Wrappers.<ManagementEntity>lambdaQuery();
            lambdachange.eq(ManagementEntity::getIsTerm, 0);
            List<ManagementEntity> list= service.list(lambdachange);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("开始循环设置----"+list.size());
                list.forEach(entity -> {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        if(1==entity.getIsTerm()){
                            entity.setTermStatus(0);
                        }else{
                            Date failureDate = sdf.parse(sdf.format(entity.getFailureDate()));
                            Date now = sdf.parse(sdf.format(new Date()));
                            long nd = 1000 * 24 * 60 * 60;
                            long diff = failureDate.getTime() - now.getTime();
                            long day = diff / nd;
                            if(day>num){
                                entity.setTermStatus(0);
                            }else if(day<=num&&day>=0){
                                entity.setTermStatus(1);
                            }else if(day<0){
                                entity.setTermStatus(2);
                            }
                        }
                    } catch (Exception e) {
                        logger.error("信息异常：", e);
                    }

                });
                service.updateBatchById(list);
            }
        }
        return CommonResponse.success("运行成功！");
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadOrg")
    @ResponseBody
    public void downloadOrg(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "cert-org-import.xlsx", "企业证照导入模板");
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "cert-import.xlsx", "个人证照导入模板");
    }

    /**
     * 查询个人证照档案信息
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryPersonalInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ManagementVO> queryReceiveInfo(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<ManagementEntity> entityList = service.queryList(queryParam, false);
        ManagementVO backVO = !entityList.isEmpty() ? BeanMapper.map(entityList.get(0), ManagementVO.class) : new ManagementVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportOrg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportOrg(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportOrg(request,response);
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }
}
