package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WorkLogEntity;
import com.ejianc.business.oa.service.IWorkLogService;
import com.ejianc.business.oa.vo.WorkLogVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 施工日志
 *
 * @author generator
 */
@Controller
@RequestMapping("workLog")
public class WorkLogController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";

    private static final String WORK_LOG_BILL_CODE = "WORK_LOG";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkLogService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkLogVO> saveOrUpdate(@RequestBody WorkLogVO saveorUpdateVO) {
        WorkLogEntity entity = BeanMapper.map(saveorUpdateVO, WorkLogEntity.class);
        if (entity.getId() == null) {
            if (StringUtils.isEmpty(entity.getCode())) {
                Long tenantId = InvocationInfoProxy.getTenantid();
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WORK_LOG_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    entity.setCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            if (entity.getOrgId() == null) {
                entity.setOrgId(InvocationInfoProxy.getOrgId());
            }
            if (StringUtils.isEmpty(entity.getLoggerName())) {
                entity.setLoggerName(sessionManager.getUserContext().getUserName());
            }
            if (entity.getLoggerId() == null) {
                entity.setLoggerId(sessionManager.getUserContext().getEmployeeId());
            }
        }
        service.saveOrUpdate(entity, false);
        //为了区分图片与附件,根据单据id获取上传的图片
        CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), "BT210525000000001", "photoLog", null);
        if (response.isSuccess()) {
            List<AttachmentVO> attaList = response.getData();
            LambdaUpdateWrapper<WorkLogEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(WorkLogEntity::getId, entity.getId());
            updateWrapper.set(WorkLogEntity::getPhotoNum, CollectionUtils.isEmpty(attaList) ? 0 : attaList.size());
            service.update(updateWrapper);
        }
        WorkLogVO vo = BeanMapper.map(entity, WorkLogVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkLogVO> queryDetail(Long id) {
        WorkLogEntity entity = service.selectById(id);
        WorkLogVO vo = BeanMapper.map(entity, WorkLogVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkLogVO> vos) {
        service.removeByIds(vos.stream().map(WorkLogVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkLogVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("loggerName");
        fuzzyFields.add("materialEnter");
        fuzzyFields.add("logInfo");
        fuzzyFields.add("existProblem");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        //移动端和pc端权限处理
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<WorkLogEntity> page = service.queryPage(param, false);
        IPage<WorkLogVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkLogVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/5/27 查询天气 以及 上一次记录内容
     * @Description queryWeatherAndLastContent
     * @Param [p, c, d]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.oa.vo.WorkLogVO>
     */
    @RequestMapping(value = "/queryWeatherAndLastContent", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryWeatherAndLastContent(@RequestParam("p") String p, @RequestParam("c") String c, @RequestParam(value = "d", required = false) String d, HttpServletRequest request) throws UnsupportedEncodingException {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        String projectId = request.getParameter("projectId");
        if (StringUtils.isNotEmpty(projectId)) {
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<WorkLogEntity> page = service.queryList(param, false);
        if (ListUtil.isNotEmpty(page)) {
            res.put("logInfo", page.get(0).getLogInfo());
        } else {
            res.put("logInfo", null);
        }
        String url = qqWeatherUrl + URLEncoder.encode(p, "UTF-8");
        if (StringUtils.isEmpty(c)) {
            url = url + "&city=" + URLEncoder.encode(p, "UTF-8");
        } else {
            url = url + "&city=" + URLEncoder.encode(c, "UTF-8");
        }

        String weather = null;
        try {
            weather = ReferHttpClientUtils.get(url, request);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("{}{}{}{}", p, c, d, weather);
        if (StringUtils.isNotEmpty(weather)) {
            res.put("weather", JSONObject.parseObject(weather));
        } else {
            res.put("weather", null);
        }
        return CommonResponse.success("查询详情数据成功！", res);
    }


    @RequestMapping(value = "/queryLastContent", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryLastContent(@RequestParam("projectId") String projectId) {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<WorkLogEntity> page = service.queryList(param, false);
        if (ListUtil.isNotEmpty(page)) {
            res.put("logInfo", page.get(0).getLogInfo());
        } else {
            res.put("logInfo", null);
        }
        return CommonResponse.success("查询详情数据成功！", res);
    }

    /**
     * @Author xuannl
     * @Date 2021/10/25 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("loggerName");
        fuzzyFields.add("materialEnter");
        fuzzyFields.add("logInfo");
        fuzzyFields.add("existProblem");

        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<WorkLogEntity> voPage = service.queryPage(queryParam, false);
        List<WorkLogEntity> list = voPage.getRecords();

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        String fileName = "workLogExport.xlsx";
        ExcelExport.getInstance().exportWithTrans(fileName, beans, response);
    }


    /**
     * @description: 项目考勤表
     *
     * @param param
     * @return {@link com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.alibaba.fastjson.JSONObject>>}
     * @author songlx
     * @date: 2023/10/17
     */
    @RequestMapping(value = "/queryWorkTeamReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryWorkTeamReport(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Page<JSONObject> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Parameter monthDatePa = param.getParams().get("monthDate");
        if (null == monthDatePa || monthDatePa.getValue() == null) {
            throw new BusinessException("月份不能为空！");
        }
        String monthDate = String.valueOf(monthDatePa.getValue());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("projectId", "teamName");
        List<JSONObject> list = service.queryWorkTeamReport(page, wrapper, monthDate);
        IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success(pageData);
    }

    /**
     * @description: 项目考勤表-导出
     *
     * @return
     * @author songlx
     * @date: 2023/10/18
     */
    @RequestMapping(value = "/excelExportWorkTeamReport", method = RequestMethod.POST)
    @ResponseBody
    public void queryWorkTeamReport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageIndex(0);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Page<JSONObject> page = new Page<>(param.getPageIndex(), param.getPageSize());
        Parameter monthDatePa = param.getParams().get("monthDate");
        if (null == monthDatePa || monthDatePa.getValue() == null) {
            throw new BusinessException("月份不能为空！");
        }
        String monthDate = String.valueOf(monthDatePa.getValue());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("projectId", "teamName", "logDay");
        List<JSONObject> list = service.queryWorkTeamReport(page, wrapper, monthDate);

        List<JSONObject> head = new LinkedList<>();

        JSONObject projectHead = new JSONObject();
        projectHead.put("key", "projectName");
        projectHead.put("name", "项目名称");
        head.add(projectHead);

        JSONObject teamHead = new JSONObject();
        teamHead.put("key", "teamName");
        teamHead.put("name", "班组名称");
        head.add(teamHead);

        // 获取月份的天数
        int daysInMonth = LocalDate.parse(monthDate + "-01").lengthOfMonth();
        for (int i = 1; i <= daysInMonth; i++) {
            JSONObject hh = new JSONObject();
            hh.put("key", i + "_num");
            hh.put("name", i + "号");
            head.add(hh);
        }

        JSONObject totalHead = new JSONObject();
        totalHead.put("key", "total_num");
        totalHead.put("name", "合计");
        head.add(totalHead);

        int lastColIndex = head.size();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, lastColIndex - 1));

        //首行标题
        XSSFRow row = sheet.createRow(0);
        CellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern(CellStyle.SOLID_FOREGROUND);
        style.setAlignment(CellStyle.ALIGN_CENTER);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("项目考勤表" + monthDate);
        cell.setCellStyle(style);
        //第二行列名
        row = sheet.createRow(1);
        for (int a = 0; a < head.size(); a++) {
            cell = row.createCell(a);
            cell.setCellValue(head.get(a).get("name").toString());
            cell.setCellStyle(style);
        }
        for (int i = 0; i < lastColIndex; i++) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 25 / 10);
        }

        CellStyle dataStyle = workbook.createCellStyle();
        dataStyle.setAlignment(CellStyle.ALIGN_RIGHT);
        for (int i = 0; i < list.size(); i++) {
            JSONObject vo = list.get(i);
            row = sheet.createRow(i + 2);
            for (int j = 0; j < lastColIndex; j++) {
                String key = head.get(j).get("key").toString();
                cell = row.createCell(j);
                if (key.contains("num")) {
                    if (vo.get(key) != null) {
                        cell.setCellValue(Integer.parseInt(vo.get(key).toString()));
                    }
                    cell.setCellStyle(dataStyle);
                } else {
                    String val = vo.get(key) == null ? "" : vo.get(key).toString();
                    cell.setCellValue(val);
                }
            }
        }
        workbook.write(outputStream);
    }




    @RequestMapping(value = "/queryLogCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryLogCount(@RequestParam("projectId") String projectId, @RequestParam(value = "logDate", required = false) String logDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Map<String, Object> map = new HashMap<>();
        LocalDate today = LocalDate.now();
        String curDay = today.format(dateTimeFormatter);

        LambdaQueryWrapper<WorkLogEntity> totalWrapper = new LambdaQueryWrapper<>();
        totalWrapper.in(WorkLogEntity::getBillState, 1,3);
        totalWrapper.eq(WorkLogEntity::getProjectId, projectId);
        int count = service.count(totalWrapper);
        map.put("total", count);

        LambdaQueryWrapper<WorkLogEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(WorkLogEntity::getBillState, 1,3);
        wrapper.eq(WorkLogEntity::getProjectId, projectId);
        wrapper.eq(WorkLogEntity::getLogDate, Optional.ofNullable(logDate).orElse(curDay));
        List<WorkLogEntity> list = service.list(wrapper);
        map.put("todayLogNum", list.size());
        int workerNum = list.stream().filter(t -> t.getTotalPersonNum() != null).mapToInt(user -> user.getTotalPersonNum()).sum();
        map.put("todayWorkerNum", workerNum);

        // 获取最近30天的日志图片
        LocalDate thirtyDaysBefore = today.minusDays(30);
        String thirtyDays = thirtyDaysBefore.format(dateTimeFormatter);

        LambdaQueryWrapper<WorkLogEntity> imageBillWrapper = new LambdaQueryWrapper<>();
        imageBillWrapper.in(WorkLogEntity::getBillState, 1,3);
        imageBillWrapper.eq(WorkLogEntity::getProjectId, projectId);
        imageBillWrapper.between(WorkLogEntity::getLogDate, thirtyDays, curDay);
        imageBillWrapper.gt(WorkLogEntity::getPhotoNum, 0);
        imageBillWrapper.groupBy(WorkLogEntity::getLogDate);
        imageBillWrapper.orderByDesc(WorkLogEntity::getLogDate);
        imageBillWrapper.last("limit 30");
        List<WorkLogEntity> billList = service.list(imageBillWrapper);

        List<Map<String, Object>> imageList = new LinkedList<>();
        Map<Long, AttachmentVO> fileMap = new HashMap<>();
        Map<String, Long> billMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(billList)) {
            JSONArray sourceIds = new JSONArray();
            for (WorkLogEntity workLogEntity : billList) {
                Date date = workLogEntity.getLogDate();
                if (date == null) {
                    continue;
                }
                billMap.put(sdf.format(date), workLogEntity.getId());
                sourceIds.add(workLogEntity.getId());
            }
            JSONObject param = new JSONObject();
            param.put("sourceIds", sourceIds.toJSONString());
            JSONArray sourceTypeList = new JSONArray();
            sourceTypeList.add("photoLog");
            param.put("sourceTypeList", sourceTypeList.toJSONString());
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(param);
            if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null) {
                List<AttachmentVO> data = listCommonResponse.getData();
                fileMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity(), (e1, e2) -> e1));
            }

            for (int i = (billList.size() - 1); i >= 0; i--) {
                WorkLogEntity workLogEntity = billList.get(i);
                String day = sdf.format(workLogEntity.getLogDate());
                Map<String, Object> dayMap = new HashMap<>();
                dayMap.put("date", day);
                Long billId = billMap.get(day);
                AttachmentVO attachmentVO = fileMap.get(billId);
                if (attachmentVO != null) {
                    dayMap.put("fileId", attachmentVO.getId());
                    dayMap.put("onlinePath", attachmentVO.getOnlinePath());
                    imageList.add(dayMap);
                }

            }
        }

        map.put("imageList", imageList);


        List<Map<String, Object>> curMonthData = new LinkedList<>();
        QueryWrapper<WorkLogEntity> curMonthWrapper = new QueryWrapper<>();
        curMonthWrapper.select("DATE_FORMAT( log_date, '%Y-%m-%d' ) AS memo");
        curMonthWrapper.in("bill_state", 1,3);
        curMonthWrapper.eq("project_id", projectId);
        curMonthWrapper.apply( "DATE_FORMAT( log_date, '%Y-%m' ) = DATE_FORMAT( CURRENT_DATE (), '%Y-%m' )");
        curMonthWrapper.groupBy("DATE_FORMAT( log_date, '%Y-%m-%d' )");
        List<WorkLogEntity> curMonthBillList = service.list(curMonthWrapper);
        List<String> dayList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(curMonthBillList)){
            dayList = curMonthBillList.stream().map(WorkLogEntity::getMemo).collect(Collectors.toList());
        }

        for (int i = 1; i <= today.lengthOfMonth(); i++) {
            LocalDate date = today.withDayOfMonth(i);
            Map<String, Object> dayMap = new HashMap<>();
            String day = date.format(dateTimeFormatter);
            dayMap.put("date", day);
            dayMap.put("flag", dayList.contains(day));
            curMonthData.add(dayMap);
        }
        map.put("curMonthData", curMonthData);

        return CommonResponse.success("项目门户-施工日志分析！", map);
    }





}
