/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.snapshort.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.snapshort.bean.SnapshotEntity;
import com.ejianc.business.snapshort.bean.SnapshotFileEntity;
import com.ejianc.business.snapshort.bean.SnapshotRelationEntity;
import com.ejianc.business.snapshort.service.ISnapshotFileService;
import com.ejianc.business.snapshort.service.ISnapshotRelationService;
import com.ejianc.business.snapshort.service.ISnapshotService;
import com.ejianc.business.snapshort.vo.SnapshotFileVO;
import com.ejianc.business.snapshort.vo.SnapshotVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"snapshot"})
public class SnapshotController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISnapshotService service;
    @Autowired
    private ISnapshotFileService snapshotFileService;
    @Autowired
    private ISnapshotRelationService snapshotRelationService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SnapshotVO> saveOrUpdate(@RequestBody SnapshotVO saveOrUpdateVO) {
        SnapshotEntity entity = (SnapshotEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SnapshotEntity.class));
        entity.setUploadUserId(this.sessionManager.getUserContext().getUserId());
        entity.setUploadUserName(this.sessionManager.getUserContext().getUserName());
        if (saveOrUpdateVO.getId() == null) {
            entity.setUploadTime(new Date());
        }
        List<SnapshotFileEntity> fileList = entity.getFileList();
        fileList.forEach(vo -> {
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setParentOrgId(entity.getParentOrgId());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setDescription(entity.getDescription());
            vo.setMarkId(entity.getMarkId());
            vo.setMarkName(entity.getMarkName());
            vo.setUploadUserId(entity.getUploadUserId());
            vo.setUploadUserName(entity.getUploadUserName());
            vo.setUploadTime(entity.getUploadTime());
        });
        this.service.saveOrUpdate((Object)entity, false);
        SnapshotVO vo2 = (SnapshotVO)BeanMapper.map((Object)((Object)entity), SnapshotVO.class);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SnapshotRelationEntity::getPid, (Object)entity.getId());
        this.snapshotRelationService.remove((Wrapper)lambda);
        String markId = saveOrUpdateVO.getMarkId();
        if (StringUtils.isNotBlank((CharSequence)markId)) {
            String[] split = markId.split(",");
            List<String> list = Arrays.asList(split);
            List longList = list.stream().map(Long::parseLong).collect(Collectors.toList());
            ArrayList<SnapshotRelationEntity> snapshotRelationEntities = new ArrayList<SnapshotRelationEntity>();
            for (Long id : longList) {
                SnapshotRelationEntity snapshotRelationEntity = new SnapshotRelationEntity();
                snapshotRelationEntity.setMarkId(id);
                snapshotRelationEntity.setPid(entity.getId());
                snapshotRelationEntities.add(snapshotRelationEntity);
            }
            this.snapshotRelationService.saveOrUpdateBatch(snapshotRelationEntities);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo2);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SnapshotVO> queryDetail(Long id) {
        SnapshotEntity entity = (SnapshotEntity)((Object)this.service.selectById(id));
        SnapshotVO vo = (SnapshotVO)BeanMapper.map((Object)((Object)entity), SnapshotVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SnapshotVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SnapshotVO snapshotVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SnapshotVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("description");
        fuzzyFields.add("markName");
        fuzzyFields.add("uploadUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Long orgId = InvocationInfoProxy.getOrgId();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (param.getParams().containsKey("markId")) {
            String markId = ((Parameter)param.getParams().get("markId")).getValue().toString();
            param.getParams().remove("markId");
            if (StringUtils.isNotBlank((CharSequence)markId)) {
                String[] split = markId.split(",");
                List<String> list = Arrays.asList(split);
                List longList = list.stream().map(Long::parseLong).collect(Collectors.toList());
                LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
                lambda.in(SnapshotRelationEntity::getMarkId, longList);
                List listRelation = this.snapshotRelationService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)listRelation)) {
                    List pids = listRelation.stream().map(SnapshotRelationEntity::getPid).distinct().collect(Collectors.toList());
                    param.getParams().put("id", new Parameter("in", pids));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List snapshotVOList = BeanMapper.mapList((Iterable)page.getRecords(), SnapshotVO.class);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)snapshotVOList)) {
            List ids = snapshotVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(SnapshotFileEntity::getPid, ids);
            List entities = this.snapshotFileService.list((Wrapper)lambda);
            List snapshotFileVOS = BeanMapper.mapList((Iterable)entities, SnapshotFileVO.class);
            map = snapshotFileVOS.stream().collect(Collectors.groupingBy(s -> s.getPid()));
        }
        for (SnapshotVO snapshotVO : snapshotVOList) {
            if (!map.containsKey(snapshotVO.getId())) continue;
            List snapshotFileEntities = (List)map.get(snapshotVO.getId());
            snapshotVO.setFileList(snapshotFileEntities);
        }
        pageData.setRecords(snapshotVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryProjectList(@RequestBody QueryParam param) {
        String formattedDate;
        LambdaQueryWrapper lambda;
        List<String> list;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("description");
        fuzzyFields.add("markName");
        fuzzyFields.add("uploadUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String projectIdString = ((Parameter)param.getParams().get("projectId")).getValue().toString();
        Long projectId = Long.valueOf(projectIdString);
        param.getParams().remove("projectId");
        Long userId = null;
        String userType = null;
        if (param.getParams().containsKey("userType")) {
            userType = ((Parameter)param.getParams().get("userType")).getValue().toString();
            param.getParams().remove("userType");
            if (userType.equals("1")) {
                userId = this.sessionManager.getUserContext().getUserId();
            }
            if (userType.equals("2")) {
                userId = this.sessionManager.getUserContext().getUserId();
            }
        }
        List<Long> pids = new ArrayList<Long>();
        if (param.getParams().containsKey("markId")) {
            String markId = ((Parameter)param.getParams().get("markId")).getValue().toString();
            param.getParams().remove("markId");
            if (StringUtils.isNotBlank((CharSequence)markId)) {
                String[] split = markId.split(",");
                list = Arrays.asList(split);
                List longList = list.stream().map(Long::parseLong).collect(Collectors.toList());
                lambda = Wrappers.lambdaQuery();
                lambda.in(SnapshotRelationEntity::getMarkId, longList);
                List listRelation = this.snapshotRelationService.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)listRelation)) {
                    pids = listRelation.stream().map(SnapshotRelationEntity::getPid).distinct().collect(Collectors.toList());
                }
            }
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        list = this.service.queryProjectList((Page<SnapshotVO>)page, wrapper, projectId, userType, pids, userId);
        Map<Object, Object> map = new HashMap();
        lambda = Wrappers.lambdaQuery();
        lambda.in(pids.size() > 0, SnapshotFileEntity::getPid, pids);
        lambda.in(SnapshotFileEntity::getProjectId, new Object[]{projectId});
        lambda.eq(userType != null && userType.equals("1"), SnapshotFileEntity::getUploadUserId, (Object)userId);
        lambda.ne(userType != null && userType.equals("2"), SnapshotFileEntity::getUploadUserId, (Object)userId);
        List entities = this.snapshotFileService.list((Wrapper)lambda);
        List snapshotFileVOS = BeanMapper.mapList((Iterable)entities, SnapshotFileVO.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (SnapshotFileVO snapshotFileVO : snapshotFileVOS) {
            formattedDate = sdf.format(snapshotFileVO.getUploadTime());
            snapshotFileVO.setUpDate(formattedDate);
        }
        map = snapshotFileVOS.stream().collect(Collectors.groupingBy(s -> s.getUpDate()));
        for (SnapshotVO snapshotVO : list) {
            formattedDate = sdf.format(snapshotVO.getUploadTime());
            if (!map.containsKey(formattedDate)) continue;
            List snapshotFileEntities = (List)map.get(formattedDate);
            snapshotVO.setFileList(snapshotFileEntities);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Snapshot-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSnapshotData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SnapshotVO>> refSnapshotData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SnapshotVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

